/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.displacement.MentalDisplacementSpellEffect;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.networking.MentalDisplacementUpdatePacket;
import stepsword.mahoutsukai.networking.PacketHandler;

public class MentalDisplacementEntity
extends Entity {
    public static final String entityName = "mental_displacement";
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(MentalDisplacementEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    public BlockPos origPos;
    public PlayerEntity player;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean backInputDown;
    private boolean forwardInputDown;
    private boolean leftInputDown;
    private boolean rightInputDown;
    private boolean upInputDown;
    private boolean downInputDown;
    public boolean used = false;

    public MentalDisplacementEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.MENTAL_DISPLACEMENT, worldIn);
        this.field_70158_ak = true;
    }

    public MentalDisplacementEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public MentalDisplacementEntity(World world) {
        super(ModEntities.MENTAL_DISPLACEMENT, world);
        this.origPos = null;
        this.player = null;
    }

    public MentalDisplacementEntity(World world, BlockPos o, PlayerEntity p) {
        this(world);
        this.origPos = o;
        this.player = p;
        this.func_70107_b(this.origPos.func_177958_n(), this.origPos.func_177956_o(), this.origPos.func_177952_p());
        this.func_213293_j(0.0, 0.0, 0.0);
        this.field_70177_z = p.field_70177_z;
        this.field_70125_A = p.field_70125_A;
    }

    private void tickLerp() {
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public boolean func_184186_bw() {
        return false;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = posRotationIncrements;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.player == null) {
                this.func_70106_y();
                return;
            }
            if (!this.player.func_70089_S()) {
                this.func_70106_y();
                return;
            }
            if (MentalDisplacementSpellEffect.checkDistance(this.player.func_233580_cy_(), this.func_233580_cy_()) > MTConfig.MENTAL_DISPLACEMENT_RANGE) {
                this.func_70106_y();
                return;
            }
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        Vector3d motion = this.func_213322_ci();
        Vector3d position = this.func_213303_ch().func_178787_e(motion);
        this.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
        this.tickLerp();
        this.playerControl();
    }

    public void playerControl() {
        if (this.field_70170_p.field_72995_K) {
            float moveSpeed = 0.01f;
            float slowFactor = 0.1f;
            float f = 1.0E-8f;
            float l = 1.0E-8f;
            float u = 0.0f;
            float fm = 0.0f;
            float lm = 0.0f;
            float um = 1.0f;
            if (this.backInputDown) {
                f += -moveSpeed;
            }
            if (this.forwardInputDown) {
                f += moveSpeed;
            }
            if (this.leftInputDown) {
                l += moveSpeed;
            }
            if (this.rightInputDown) {
                l += -moveSpeed;
            }
            if (this.upInputDown) {
                u += moveSpeed;
            }
            if (this.downInputDown) {
                u += -moveSpeed;
            }
            if (!this.forwardInputDown && !this.backInputDown) {
                fm = 1.0f;
            }
            if (!this.leftInputDown && !this.rightInputDown) {
                lm = 1.0f;
            }
            if (!this.upInputDown && !this.downInputDown) {
                um = slowFactor;
            }
            Vector3d motion = this.func_213322_ci();
            this.func_213293_j(motion.field_72450_a + (double)(-(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)) + (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * l), motion.field_72448_b, motion.field_72449_c + (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f) + (double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * l));
            motion = this.func_213322_ci();
            double g = Math.sqrt(motion.field_72450_a * motion.field_72450_a + motion.field_72449_c * motion.field_72449_c);
            float angle = (float)(-Math.atan2(motion.field_72450_a, motion.field_72449_c)) * 57.2958f;
            double c = g * (double)MathHelper.func_76134_b((float)((angle - this.field_70177_z + 90.0f) * ((float)Math.PI / 180)));
            double c2 = c * (double)MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            double c1 = c * (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            double d = g * (double)MathHelper.func_76134_b((float)((angle - this.field_70177_z) * ((float)Math.PI / 180)));
            double d2 = -d * (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            double d1 = d * (double)MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.func_213293_j(motion.field_72450_a - (double)lm * c2 - (double)fm * d2, (double)um * ((double)u + motion.field_72448_b), motion.field_72449_c - (double)lm * c1 - (double)fm * d1);
            Vector3d v = this.func_213303_ch().func_178787_e(this.func_213322_ci());
            this.func_70107_b(v.field_72450_a, v.field_72448_b, v.field_72449_c);
            Vector3d dm = this.func_213322_ci();
            Vector3d pp = this.func_213303_ch();
            PacketHandler.sendToServer(new MentalDisplacementUpdatePacket(this, pp.field_72450_a, pp.field_72448_b, pp.field_72449_c, dm.field_72450_a, dm.field_72448_b, dm.field_72449_c, this.field_70177_z, this.field_70125_A));
        }
    }

    public void updatePacket(MentalDisplacementUpdatePacket packet) {
        this.func_70107_b(packet.x, packet.y, packet.z);
        this.func_213293_j(packet.vx, packet.vy, packet.vz);
        this.func_70101_b((float)packet.yaw, (float)packet.pitch);
    }

    public void updateInputs(boolean b, boolean f, boolean l, boolean r, boolean u, boolean d) {
        this.backInputDown = b;
        this.forwardInputDown = f;
        this.leftInputDown = l;
        this.rightInputDown = r;
        this.upInputDown = u;
        this.downInputDown = d;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orElse(UUID.randomUUID());
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, Optional.ofNullable(uuid));
    }

    public void func_70037_a(CompoundNBT compound) {
        this.used = compound.func_74767_n("mahoutsukai_used");
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74757_a("mahoutsukai_used", this.used);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AxisAlignedBB func_174813_aQ() {
        return new AxisAlignedBB(this.func_226277_ct_() - 0.1, this.func_226278_cu_() - 0.1, this.func_226281_cx_() - 0.1, this.func_226277_ct_() + 0.1, this.func_226278_cu_() + 0.1, this.func_226281_cx_() + 0.1);
    }

    public AxisAlignedBB func_184177_bl() {
        return new AxisAlignedBB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }
}

