/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block;

import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.FogProjectorTileEntity;
import stepsword.mahoutsukai.util.ChunkDim;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.FogProjectorValues;
import stepsword.mahoutsukai.util.Utils;

public class FogProjector
extends BlockTileEntity<FogProjectorTileEntity> {
    public static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB boundingBoxE = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static HashSet<ChunkDim> projectors = new HashSet();

    public FogProjector() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_(), "fog_projector");
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult resulr) {
        if (world.func_175625_s(pos) instanceof FogProjectorTileEntity) {
            FogProjectorTileEntity te = (FogProjectorTileEntity)world.func_175625_s(pos);
            if (player.func_184614_ca().func_77973_b() != Items.field_151055_y && world.field_72995_K) {
                MahouTsukaiMod.proxy.openFogProjectorGUI(world, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static void fogProjectorRightClick(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        if (world.func_175625_s(pos) instanceof FogProjectorTileEntity) {
            FogProjectorTileEntity te = (FogProjectorTileEntity)world.func_175625_s(pos);
            if (!world.field_72995_K && player.func_184614_ca().func_77973_b() == Items.field_151055_y) {
                if (player.func_226273_bm_()) {
                    CompoundNBT nbt = FogProjectorTileEntity.getProjectorNBT(player.func_184614_ca());
                    if (nbt != null && te != null) {
                        FogProjectorValues pv = new FogProjectorValues();
                        pv.read(nbt);
                        te.set_particle_fog_size(pv.get_particle_fog_size());
                        te.set_particle_fog_color_r(pv.get_particle_fog_color_r());
                        te.set_particle_fog_color_g(pv.get_particle_fog_color_g());
                        te.set_particle_fog_color_b(pv.get_particle_fog_color_b());
                        te.set_particle_fog_color_a(pv.get_particle_fog_color_a());
                        te.set_particle_fog_thickness(pv.get_particle_fog_thickness());
                        te.set_particle_fog_speed(pv.get_particle_fog_speed());
                        te.set_particle_fog_random_x(pv.get_particle_fog_random_x());
                        te.set_particle_fog_random_y(pv.get_particle_fog_random_y());
                        te.set_particle_fog_random_z(pv.get_particle_fog_random_z());
                        te.set_particle_fog_direction_x(pv.get_particle_fog_direction_x());
                        te.set_particle_fog_direction_y(pv.get_particle_fog_direction_y());
                        te.set_particle_fog_direction_z(pv.get_particle_fog_direction_z());
                        te.set_particle_fog_shaders(pv.get_particle_fog_shaders());
                        te.set_particle_fog_frequency_num(pv.get_particle_fog_frequency_num());
                        te.set_particle_fog_frequency_ticks(pv.get_particle_fog_frequency_ticks());
                        te.set_camera_fog_radius(pv.get_camera_fog_radius());
                        te.set_camera_fog_color_r(pv.get_camera_fog_color_r());
                        te.set_camera_fog_color_g(pv.get_camera_fog_color_g());
                        te.set_camera_fog_color_b(pv.get_camera_fog_color_b());
                        te.set_camera_fog_strength(pv.get_camera_fog_strength());
                        te.set_camera_fog_toggle(pv.get_camera_fog_toggle());
                        te.sendUpdates();
                    }
                } else {
                    FogProjectorTileEntity.setProjectorNBT(player.func_184614_ca(), te);
                }
            }
        }
    }

    @Override
    public Class<FogProjectorTileEntity> getTileEntityClass() {
        return FogProjectorTileEntity.class;
    }

    @Override
    @Nullable
    public FogProjectorTileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FogProjectorTileEntity();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState state2, boolean v1) {
        if (!world.field_72995_K) {
            IChunkMahou chunkMahou;
            IChunk c = world.func_217349_x(pos);
            if (c instanceof Chunk && (chunkMahou = Utils.getChunkMahou((Chunk)c)) != null && chunkMahou.getFogProjectors() != null) {
                chunkMahou.getFogProjectors().remove((Object)pos);
            }
            if (projectors == null) {
                projectors = new HashSet();
            }
            projectors.add(new ChunkDim(c.func_76632_l(), EffectUtil.getDimension(world)));
        }
        super.func_196243_a(state, world, pos, state2, v1);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.field_72995_K) {
            IChunkMahou chunkMahou;
            IChunk c = world.func_217349_x(pos);
            if (c instanceof Chunk && (chunkMahou = Utils.getChunkMahou((Chunk)c)) != null && chunkMahou.getFogProjectors() != null) {
                chunkMahou.getFogProjectors().add((Object)pos);
            }
            if (projectors == null) {
                projectors = new HashSet();
            }
            projectors.add(new ChunkDim(c.func_76632_l(), EffectUtil.getDimension(world)));
        }
        super.func_220082_b(state, world, pos, oldState, isMoving);
    }

    public static void fogUpdateTick(TickEvent.WorldTickEvent event) {
        if (!event.world.field_72995_K && event.phase == TickEvent.Phase.END && event.world.func_82737_E() % 4L == 0L) {
            for (ChunkDim p : projectors) {
                ServerWorld world = EffectUtil.getNewDimensionByName((ServerWorld)event.world, p.dim);
                Chunk c = world.func_212866_a_(p.pos.field_77276_a, p.pos.field_77275_b);
                IChunkMahou chunkMahou = Utils.getChunkMahou(c);
                if (chunkMahou == null) continue;
                PacketHandler.sendTrackingBlock(p.pos.func_206849_h(), (World)EffectUtil.getNewDimensionByName((ServerWorld)event.world, p.dim), new ChunkMahouPacket(chunkMahou.getFogProjectors(), p.pos.field_77276_a, p.pos.field_77275_b, 1));
            }
            projectors.clear();
        }
    }
}

