/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import org.apache.commons.lang3.tuple.Pair;

public class Condition
implements ILostCityAsset {
    private String name;
    private final List<Pair<Predicate<ConditionContext>, Pair<Float, String>>> valueSelector = new ArrayList<Pair<Predicate<ConditionContext>, Pair<Float, String>>>();

    public Condition(JsonObject object) {
        this.readFromJSon(object);
    }

    public Condition(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        JsonArray array = object.get("values").getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject o = element.getAsJsonObject();
            float factor = o.get("factor").getAsFloat();
            String value = o.get("value").getAsString();
            Predicate<ConditionContext> test = ConditionContext.parseTest(element);
            this.valueSelector.add((Pair<Predicate<ConditionContext>, Pair<Float, String>>)Pair.of(test, (Object)Pair.of((Object)Float.valueOf(factor), (Object)value)));
        }
    }

    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("condition"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        return object;
    }

    public String getRandomValue(Random random, ConditionContext info) {
        ArrayList<Pair<Float, String>> values = new ArrayList<Pair<Float, String>>();
        for (Pair<Predicate<ConditionContext>, Pair<Float, String>> pair : this.valueSelector) {
            if (!((Predicate)pair.getLeft()).test(info)) continue;
            values.add((Pair<Float, String>)((Pair)pair.getRight()));
        }
        if (values.isEmpty()) {
            return null;
        }
        return Tools.getRandomFromList(random, values);
    }
}

