/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.setup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.network.PacketHandler;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.ForgeEventHandlers;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModSetup {
    public static boolean chisel = false;
    public static boolean biomesoplenty = false;
    public static boolean atg = false;
    public static Logger logger = null;

    public static Logger getLogger() {
        return logger;
    }

    public void init(FMLCommonSetupEvent e) {
        logger = LogManager.getLogger();
        LostCityConfiguration.setupProfiles();
        PacketHandler.registerMessages("lostcities");
        LostCityFeature.registerConfiguredFeatures();
        this.setupModCompat();
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        this.readAssets();
        this.makeExamples();
    }

    private void makeExamples() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        File dir = new File(configPath + File.separator + "lostcities" + File.separator + "examples");
        dir.mkdirs();
        File exampleConditions = new File(configPath + File.separator + "lostcities" + File.separator + "examples" + File.separator + "conditions.json");
        try {
            FileWriter writer = new FileWriter(exampleConditions);
            writer.append("// This is an example set of conditions that you can use and modify and put\n");
            writer.append("// into (for example) config/lostcities/userassets.json\n\n");
            InputStream inputstream = LostCities.class.getResourceAsStream("/assets/lostcities/citydata/conditions.json");
            BufferedReader br = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));
            String line = br.readLine();
            while (line != null) {
                writer.append(line + "\n");
                line = br.readLine();
            }
            br.close();
            writer.close();
        }
        catch (IOException e) {
            LostCities.logger.warn("Could not write examples!");
        }
    }

    private void readAssets() {
        AssetRegistries.reset();
        for (String path : (List)Config.ASSETS.get()) {
            if (path.startsWith("/")) {
                try {
                    InputStream inputstream = LostCities.class.getResourceAsStream(path);
                    try {
                        AssetRegistries.load(inputstream, path);
                        continue;
                    }
                    finally {
                        if (inputstream == null) continue;
                        inputstream.close();
                        continue;
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            if (path.startsWith("$")) {
                Path configPath = FMLPaths.CONFIGDIR.get();
                File file = new File(configPath + File.separator + path.substring(1));
                AssetRegistries.load(file);
                continue;
            }
            throw new RuntimeException("Invalid path for lostcity resource in 'assets' config!");
        }
        if (LostCityConfiguration.DEBUG) {
            AssetRegistries.showStatistics();
        }
    }

    private void setupModCompat() {
        chisel = ModList.get().isLoaded("chisel");
        biomesoplenty = ModList.get().isLoaded("biomesoplenty");
    }
}

