/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import mcjty.lostcities.api.ILostCityBuilding;
import mcjty.lostcities.worldgen.lost.cityassets.ConditionContext;
import org.apache.commons.lang3.tuple.Pair;

public class Building
implements ILostCityBuilding {
    private String name;
    private int minFloors = -1;
    private int minCellars = -1;
    private int maxFloors = -1;
    private int maxCellars = -1;
    private char fillerBlock;
    private float prefersLonely = 0.0f;
    private final List<Pair<Predicate<ConditionContext>, String>> parts = new ArrayList<Pair<Predicate<ConditionContext>, String>>();
    private final List<Pair<Predicate<ConditionContext>, String>> parts2 = new ArrayList<Pair<Predicate<ConditionContext>, String>>();

    public Building(JsonObject object) {
        this.readFromJSon(object);
    }

    public Building(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        if (object.has("minfloors")) {
            this.minFloors = object.get("minfloors").getAsInt();
        }
        if (object.has("mincellars")) {
            this.minCellars = object.get("mincellars").getAsInt();
        }
        if (object.has("maxfloors")) {
            this.maxFloors = object.get("maxfloors").getAsInt();
        }
        if (object.has("maxcellars")) {
            this.maxCellars = object.get("maxcellars").getAsInt();
        }
        if (object.has("preferslonely")) {
            this.prefersLonely = object.get("preferslonely").getAsFloat();
        }
        if (!object.has("filler")) {
            throw new RuntimeException("'filler' is required for building '" + this.name + "'!");
        }
        this.fillerBlock = object.get("filler").getAsCharacter();
        this.readParts(object, this.parts, "parts");
        this.readParts(object, this.parts2, "parts2");
    }

    public void readParts(JsonObject object, List<Pair<Predicate<ConditionContext>, String>> p, String partSection) {
        p.clear();
        if (!object.has(partSection)) {
            return;
        }
        JsonArray partArray = object.get(partSection).getAsJsonArray();
        for (JsonElement element : partArray) {
            String partName = element.getAsJsonObject().get("part").getAsString();
            Predicate<ConditionContext> test = ConditionContext.parseTest(element);
            this.addPart(test, partName, p);
        }
    }

    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("building"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        JsonArray partArray = new JsonArray();
        for (Pair<Predicate<ConditionContext>, String> part : this.parts) {
            JsonObject partObject = new JsonObject();
            partObject.add("test", (JsonElement)new JsonPrimitive("@todo"));
            partObject.add("part", (JsonElement)new JsonPrimitive((String)part.getRight()));
            partArray.add((JsonElement)partObject);
        }
        object.add("parts", (JsonElement)partArray);
        return object;
    }

    public Building addPart(Predicate<ConditionContext> test, String partName, List<Pair<Predicate<ConditionContext>, String>> parts) {
        parts.add((Pair<Predicate<ConditionContext>, String>)Pair.of(test, (Object)partName));
        return this;
    }

    @Override
    public float getPrefersLonely() {
        return this.prefersLonely;
    }

    @Override
    public int getMaxFloors() {
        return this.maxFloors;
    }

    @Override
    public int getMaxCellars() {
        return this.maxCellars;
    }

    @Override
    public int getMinFloors() {
        return this.minFloors;
    }

    @Override
    public int getMinCellars() {
        return this.minCellars;
    }

    @Override
    public char getFillerBlock() {
        return this.fillerBlock;
    }

    public String getRandomPart(Random random, ConditionContext info) {
        ArrayList<String> partNames = new ArrayList<String>();
        for (Pair<Predicate<ConditionContext>, String> pair : this.parts) {
            if (!((Predicate)pair.getLeft()).test(info)) continue;
            partNames.add((String)pair.getRight());
        }
        if (partNames.isEmpty()) {
            return null;
        }
        return (String)partNames.get(random.nextInt(partNames.size()));
    }

    public String getRandomPart2(Random random, ConditionContext info) {
        ArrayList<String> partNames = new ArrayList<String>();
        for (Pair<Predicate<ConditionContext>, String> pair : this.parts2) {
            if (!((Predicate)pair.getLeft()).test(info)) continue;
            partNames.add((String)pair.getRight());
        }
        if (partNames.isEmpty()) {
            return null;
        }
        return (String)partNames.get(random.nextInt(partNames.size()));
    }
}

