/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.tile;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;

@Mod.EventBusSubscriber(modid="lootr")
public class TileTicker {
    private static final Object listLock = new Object();
    private static final Object worldLock = new Object();
    private static boolean tickingList = false;
    private static final Set<Entry> tileEntries = new LinkedHashSet<Entry>();
    private static final Set<Entry> pendingEntries = new LinkedHashSet<Entry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntry(RegistryKey<World> dimension, BlockPos position) {
        if (ConfigManager.isDimensionBlocked(dimension)) {
            return;
        }
        Entry newEntry = new Entry(dimension, position);
        Object object = listLock;
        synchronized (object) {
            if (tickingList) {
                pendingEntries.add(newEntry);
            } else {
                tileEntries.add(newEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HashSet<Entry> copy;
            HashSet<Entry> toRemove = new HashSet<Entry>();
            Object object = listLock;
            synchronized (object) {
                tickingList = true;
                copy = new HashSet<Entry>(tileEntries);
                tickingList = false;
            }
            object = worldLock;
            synchronized (object) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                for (Entry entry : copy) {
                    ServerWorld level = server.func_71218_a(entry.getDimension());
                    if (level == null) {
                        toRemove.add(entry);
                        continue;
                    }
                    ServerChunkProvider provider = level.func_72863_F();
                    ChunkPos pos = entry.getChunkPosition();
                    Chunk chunk = (Chunk)provider.func_212849_a_(pos.field_77276_a, pos.field_77275_b, ChunkStatus.field_222617_m, false);
                    if (chunk == null) continue;
                    TileEntity tile = level.func_175625_s(entry.getPosition());
                    if (!(tile instanceof LockableLootTileEntity) || tile instanceof ILootTile) {
                        toRemove.add(entry);
                        continue;
                    }
                    LockableLootTileEntity te = (LockableLootTileEntity)tile;
                    if (te.field_184284_m == null || ConfigManager.isBlacklisted(te.field_184284_m)) {
                        toRemove.add(entry);
                        continue;
                    }
                    ResourceLocation table = te.field_184284_m;
                    long seed = te.field_184285_n;
                    BlockState stateAt = level.func_180495_p(entry.getPosition());
                    BlockState replacement = ConfigManager.replacement(stateAt);
                    if (replacement == null) {
                        toRemove.add(entry);
                        continue;
                    }
                    chunk.field_201618_i.remove(entry.getPosition());
                    level.func_175713_t(entry.getPosition());
                    level.func_180501_a(entry.getPosition(), replacement, 2);
                    tile = level.func_175625_s(entry.getPosition());
                    if (tile instanceof ILootTile) {
                        ((LockableLootTileEntity)tile).func_189404_a(table, seed);
                    } else {
                        Lootr.LOG.error("replacement " + replacement + " is not an ILootTile " + entry.getDimension() + " at " + entry.getPosition());
                    }
                    toRemove.add(entry);
                }
            }
            object = listLock;
            synchronized (object) {
                tickingList = true;
                tileEntries.removeAll(toRemove);
                tileEntries.addAll(pendingEntries);
                tickingList = false;
                pendingEntries.clear();
            }
        }
    }

    public static class Entry {
        private final RegistryKey<World> dimension;
        private final BlockPos position;
        private final ChunkPos chunkPos;

        public Entry(RegistryKey<World> dimension, BlockPos position) {
            this.dimension = dimension;
            this.position = position;
            this.chunkPos = new ChunkPos(position);
        }

        public RegistryKey<World> getDimension() {
            return this.dimension;
        }

        public BlockPos getPosition() {
            return this.position;
        }

        public ChunkPos getChunkPosition() {
            return this.chunkPos;
        }
    }
}

