/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.block.tile;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.tile.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModTiles;

public class LootrChestTileEntity
extends ChestTileEntity
implements ILootTile {
    public Set<UUID> openers = new HashSet<UUID>();
    private int ticksSinceSync;
    private int specialNumPlayersUsingChest;
    private ResourceLocation savedLootTable = null;
    private long seed = -1L;
    private UUID tileId;
    private boolean opened;

    public LootrChestTileEntity() {
        super(ModTiles.LOOT_CHEST);
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public LootrChestTileEntity(TileEntityType<?> tile) {
        super(tile);
    }

    public void func_189404_a(ResourceLocation lootTableIn, long seedIn) {
        super.func_189404_a(lootTableIn, seedIn);
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public void func_184281_d(@Nullable PlayerEntity player) {
    }

    @Override
    public void fillWithLoot(PlayerEntity player, IInventory inventory, @Nullable ResourceLocation overrideTable, long seed) {
        if (this.field_145850_b != null && this.savedLootTable != null && this.field_145850_b.func_73046_m() != null) {
            LootTable loottable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(overrideTable != null ? overrideTable : this.savedLootTable);
            if (loottable == LootTable.field_186464_a) {
                Lootr.LOG.error("Unable to fill loot chest in " + this.field_145850_b.func_234923_W_() + " at " + this.field_174879_c + " as the loot table '" + (overrideTable != null ? overrideTable : this.savedLootTable) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue()) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("lootr.message.invalid_table", new Object[]{(overrideTable != null ? overrideTable : this.savedLootTable).toString()}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.DARK_RED).func_240713_a_(Boolean.valueOf(true))), Util.field_240973_b_);
                }
            }
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_232608_N_.func_235478_a_((ServerPlayerEntity)player, overrideTable != null ? overrideTable : this.field_184284_m);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)this.field_174879_c)).func_216016_a((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed));
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            }
            loottable.func_216118_a(inventory, builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_150297_b("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("specialLootChest_table"));
        }
        if (compound.func_150297_b("specialLootChest_seed", 4)) {
            this.seed = compound.func_74763_f("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.func_150297_b("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            if (this.seed == 0L && compound.func_150297_b("LootTableSeed", 4)) {
                this.seed = compound.func_74763_f("LootTableSeed");
            }
        }
        if (compound.func_186855_b("tileId")) {
            this.tileId = compound.func_186857_a("tileId");
        } else if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.func_74764_b("LootrOpeners")) {
            ListNBT openers = compound.func_150295_c("LootrOpeners", 11);
            this.openers.clear();
            for (INBT item : openers) {
                this.openers.add(NBTUtil.func_186860_b((INBT)item));
            }
        }
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        if (this.savedLootTable != null) {
            compound.func_74778_a("specialLootChest_table", this.savedLootTable.toString());
            compound.func_74778_a("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.func_74772_a("specialLootChest_seed", this.seed);
            compound.func_74772_a("LootTableSeed", this.seed);
        }
        compound.func_186854_a("tileId", this.getTileId());
        ListNBT list = new ListNBT();
        for (UUID opener : this.openers) {
            list.add((Object)NBTUtil.func_240626_a_((UUID)opener));
        }
        compound.func_218657_a("LootrOpeners", (INBT)list);
        return compound;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        this.specialNumPlayersUsingChest = LootrChestTileEntity.calculatePlayersUsingSync(this.field_145850_b, (LockableTileEntity)this, this.ticksSinceSync, i, j, k, this.specialNumPlayersUsingChest);
        this.field_145986_n = this.field_145989_m;
        if (this.specialNumPlayersUsingChest > 0 && this.field_145989_m == 0.0f) {
            this.playSound(SoundEvents.field_187657_V);
        }
        if (this.specialNumPlayersUsingChest == 0 && this.field_145989_m > 0.0f || this.specialNumPlayersUsingChest > 0 && this.field_145989_m < 1.0f) {
            float f1 = this.field_145989_m;
            this.field_145989_m = this.specialNumPlayersUsingChest > 0 ? (this.field_145989_m += 0.1f) : (this.field_145989_m -= 0.1f);
            if (this.field_145989_m > 1.0f) {
                this.field_145989_m = 1.0f;
            }
            if (this.field_145989_m < 0.5f && f1 >= 0.5f) {
                this.playSound(SoundEvents.field_187651_T);
            }
            if (this.field_145989_m < 0.0f) {
                this.field_145989_m = 0.0f;
            }
        }
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    private void playSound(SoundEvent soundIn) {
        this.field_145850_b.func_184133_a(null, this.func_174877_v(), soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public static int calculatePlayersUsingSync(World world, LockableTileEntity tile, int ticksSinceSync, int x, int y, int z, int numPlayersUsing) {
        if (!world.field_72995_K && numPlayersUsing != 0 && (ticksSinceSync + x + y + z) % 200 == 0) {
            numPlayersUsing = LootrChestTileEntity.calculatePlayersUsing(world, tile, x, y, z);
        }
        return numPlayersUsing;
    }

    public static int calculatePlayersUsing(World world, LockableTileEntity tile, int x, int y, int z) {
        if (tile == null) {
            return 0;
        }
        int i = 0;
        for (PlayerEntity playerentity : world.func_217357_a(PlayerEntity.class, new AxisAlignedBB((double)x - 5.0, (double)y - 5.0, (double)z - 5.0, (double)(x + 1) + 5.0, (double)(y + 1) + 5.0, (double)(z + 1) + 5.0))) {
            IInventory inv;
            if (!(playerentity.field_71070_bA instanceof ChestContainer) || (inv = ((ChestContainer)playerentity.field_71070_bA).func_85151_d()) == null || inv != tile && (!(inv instanceof SpecialChestInventory) || !tile.func_174877_v().equals((Object)((SpecialChestInventory)inv).getPos()))) continue;
            ++i;
        }
        return i;
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.specialNumPlayersUsingChest < 0) {
                this.specialNumPlayersUsingChest = 0;
            }
            ++this.specialNumPlayersUsingChest;
            this.func_195482_p();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.specialNumPlayersUsingChest;
            this.func_195482_p();
            this.openers.add(player.func_110124_au());
            this.func_70296_d();
            this.updatePacketViaState();
        }
    }

    @Override
    public void updatePacketViaState() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 8);
        }
    }

    protected void func_195482_p() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof ChestBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.specialNumPlayersUsingChest);
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.specialNumPlayersUsingChest = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(ModBlocks.CHEST.func_176223_P(), pkt.func_148857_g());
    }

    public static int getPlayersUsing(IBlockReader reader, BlockPos posIn) {
        TileEntity tileentity;
        BlockState blockstate = reader.func_180495_p(posIn);
        if (blockstate.hasTileEntity() && (tileentity = reader.func_175625_s(posIn)) instanceof LootrChestTileEntity) {
            return ((LootrChestTileEntity)tileentity).specialNumPlayersUsingChest;
        }
        return 0;
    }
}

