/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.repack.shoulders.client.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import noobanidus.mods.lootr.repack.shoulders.info.ShoulderData;

public interface IShoulderRidingModel {
    public void setupAnim(ShoulderData var1, int var2, float var3, float var4, float var5, float var6, float var7);

    public void prepare(ShoulderData var1);

    public RenderType getRenderType(ShoulderData var1);

    public ResourceLocation getTexture(ShoulderData var1);

    default public ResourceLocation getTexture(ShoulderData data, List<ResourceLocation> textures) {
        if (data.getVariant() >= textures.size()) {
            return textures.get(0);
        }
        return textures.get(data.getVariant());
    }

    public EntityModel<LivingEntity> getModel();

    public Iterable<ModelRenderer> getParts();

    default public float getSwing(float deg, float ageInTicks) {
        return (float)Math.sin((double)(ageInTicks * 0.125f) * (Math.PI * 2) + Math.toRadians(deg));
    }

    default public float getBobble(float deg, float ageInTicks) {
        return (float)Math.sin((double)(ageInTicks * 0.03125f) * (Math.PI * 2) + Math.toRadians(deg));
    }

    default public void setRotation(@Nonnull ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    default public void setRotateAngle(@Nonnull ModelRenderer model, float x, float y, float z) {
        this.setRotation(model, x, y, z);
    }

    default public void setRotationAngle(@Nonnull ModelRenderer model, float x, float y, float z) {
        this.setRotation(model, x, y, z);
    }

    default public void renderOnShoulder(MatrixStack pMatrixStack, ShoulderData data, IVertexBuilder pBuffer, int pPackedLight, int pPackedOverlay, float pLimbSwing, float pLimbSwingAmount, float pNetHeadYaw, float pHeadPitch, int ticks) {
        this.prepare(data);
        this.setupAnim(data, ticks, pLimbSwing, pLimbSwingAmount, 0.0f, pNetHeadYaw, pHeadPitch);
        this.getParts().forEach(part -> part.func_228308_a_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
    }

    default public void renderExtra(ShoulderData data, @Nonnull MatrixStack pMatrixStack, @Nonnull IRenderTypeBuffer pBuffer, int pPackedLight, @Nonnull PlayerEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
    }
}

