/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import owmii.lib.item.Stacks;

public class Recipe {
    public static Collection<? extends IRecipe<?>> getAll(@Nullable World world, IRecipeType<?> type) {
        if (world != null) {
            RecipeManager manager = world.func_199532_z();
            return manager.func_199510_b().stream().filter(r -> r.func_222127_g() == type).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean matchTags(ItemStack stack, ItemStack other) {
        return Recipe.matchTags(stack, other, true);
    }

    public static boolean matchTags(ItemStack stack, ItemStack other, boolean matchBlock) {
        Item item = stack.func_77973_b();
        Item item1 = stack.func_77973_b();
        if (matchBlock && item instanceof BlockItem && item1 instanceof BlockItem) {
            return Recipe.matchTags(((BlockItem)item).func_179223_d(), ((BlockItem)item1).func_179223_d());
        }
        return Recipe.matchTags(item, item1);
    }

    public static boolean matchTags(Block block, Block other) {
        for (ResourceLocation location : block.getTags()) {
            if (!Recipe.matchTags(block, location)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchTags(Block block, ResourceLocation key) {
        for (ResourceLocation location : block.getTags()) {
            if (!location.equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchTags(Item item, Item other) {
        for (ResourceLocation location : item.getTags()) {
            if (!Recipe.matchTags(item, location)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchTags(Item item, ResourceLocation key) {
        for (ResourceLocation location : item.getTags()) {
            if (!location.equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchTags(FluidStack fluid, FluidStack other) {
        return Recipe.matchTags(fluid.getFluid(), other.getFluid());
    }

    public static boolean matchTags(Fluid fluid, Fluid other) {
        for (ResourceLocation location : fluid.getTags()) {
            if (!Recipe.matchTags(fluid, location)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchTags(Fluid fluid, ResourceLocation key) {
        for (ResourceLocation location : fluid.getTags()) {
            if (!location.equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    public static Ingredient ingredientFrom(Object o) {
        if (o instanceof IItemProvider) {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)o});
        }
        if (o instanceof ITag) {
            return Ingredient.func_199805_a((ITag)((ITag)o));
        }
        if (o instanceof Ingredient) {
            return (Ingredient)o;
        }
        throw new IllegalArgumentException();
    }

    public static NonNullList<Ingredient> toNNList(Ingredient ... a) {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])a);
    }

    public static Stacks toNNList(ItemStack ... a) {
        return Stacks.from(a);
    }
}

