/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.logistics;

import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import owmii.lib.item.Stacks;
import owmii.lib.logistics.inventory.ItemInventory;
import owmii.lib.util.Recipe;
import owmii.lib.util.Stack;

public class Filter {
    private final ItemStack stack;
    private final CompoundNBT nbt;
    private final int size;

    public Filter(ItemStack stack, int size) {
        this.stack = stack;
        this.nbt = stack.func_190925_c("filter_tag");
        this.size = size;
    }

    public boolean checkStack(ItemStack stack) {
        ItemInventory inv = new ItemInventory(this.size, this.stack);
        Stacks stacks = inv.getStacks();
        Iterator iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack stack1 = (ItemStack)iterator.next();
            if (this.compareTag() && Recipe.matchTags(stack, stack1)) {
                return true;
            }
            if (stack.func_190926_b() || !stack.func_77969_a(stack1)) continue;
            if (this.compareNBT() && !Stack.isNBTEqual(stack, stack1)) {
                return false;
            }
            return !this.isBlackList();
        }
        return inv.isEmpty() || this.isBlackList();
    }

    public boolean isBlackList() {
        return this.nbt.func_74767_n("black_list");
    }

    public Filter setBlackList(boolean value) {
        this.nbt.func_74757_a("black_list", value);
        return this;
    }

    public boolean compareNBT() {
        return this.nbt.func_74767_n("compare_nbt");
    }

    public Filter setCompareNBT(boolean value) {
        this.nbt.func_74757_a("compare_nbt", value);
        return this;
    }

    public boolean compareTag() {
        return this.nbt.func_74767_n("compare_tag");
    }

    public Filter setCompareTag(boolean value) {
        this.nbt.func_74757_a("compare_tag", value);
        return this;
    }

    public void switchTag() {
        this.nbt.func_74757_a("compare_tag", !this.compareTag());
    }

    public void switchNBT() {
        this.nbt.func_74757_a("compare_nbt", !this.compareNBT());
    }

    public void switchMode() {
        this.nbt.func_74757_a("black_list", !this.isBlackList());
    }

    public void clear() {
        new ItemInventory(this.size, this.stack).clear();
    }
}

