/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.util.math;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class Box {
    private double down;
    private double up;
    private double north;
    private double south;
    private double west;
    private double east;
    private double downBase;
    private double upBase;
    private double northBase;
    private double southBase;
    private double westBase;
    private double eastBase;
    private final double min;
    private final double max;

    public Box(double dim, double min, double max) {
        this(dim, dim, dim, dim, dim, dim, min, max);
    }

    public Box(double down, double up, double north, double south, double west, double east, double min, double max) {
        this.down = down;
        this.up = up;
        this.north = north;
        this.south = south;
        this.west = west;
        this.east = east;
        this.downBase = down;
        this.upBase = up;
        this.northBase = north;
        this.southBase = south;
        this.westBase = west;
        this.eastBase = east;
        this.min = min;
        this.max = max;
    }

    public void read(CompoundNBT nbt, String key) {
        this.down = nbt.func_74769_h("down_" + key);
        this.up = nbt.func_74769_h("up_" + key);
        this.north = nbt.func_74769_h("north_" + key);
        this.south = nbt.func_74769_h("south_" + key);
        this.west = nbt.func_74769_h("west_" + key);
        this.east = nbt.func_74769_h("east_" + key);
    }

    public CompoundNBT write(CompoundNBT nbt, String key) {
        nbt.func_74780_a("down_" + key, this.down);
        nbt.func_74780_a("up_" + key, this.up);
        nbt.func_74780_a("north_" + key, this.north);
        nbt.func_74780_a("south_" + key, this.south);
        nbt.func_74780_a("west_" + key, this.west);
        nbt.func_74780_a("east_" + key, this.east);
        return nbt;
    }

    public AxisAlignedBB geAxis() {
        return this.geAxis(Vector3d.field_186680_a);
    }

    public AxisAlignedBB geAxis(BlockPos pos) {
        return this.geAxis(Vector3d.func_237491_b_((Vector3i)pos));
    }

    public AxisAlignedBB geAxis(Vector3d vector3d) {
        return new AxisAlignedBB(-this.west, -this.down, -this.north, this.east + 1.0, this.up + 1.0, this.south + 1.0).func_191194_a(vector3d);
    }

    public Box reset() {
        this.down = this.downBase;
        this.up = this.upBase;
        this.north = this.northBase;
        this.south = this.southBase;
        this.west = this.westBase;
        this.east = this.eastBase;
        return this;
    }

    public double get(Direction direction) {
        switch (direction) {
            case DOWN: {
                return this.getDown();
            }
            case UP: {
                return this.getUp();
            }
            case NORTH: {
                return this.getNorth();
            }
            case SOUTH: {
                return this.getSouth();
            }
            case WEST: {
                return this.getWest();
            }
        }
        return this.getEast();
    }

    public Box add(Direction direction, double value) {
        switch (direction) {
            case DOWN: {
                this.down(value);
                break;
            }
            case UP: {
                this.up(value);
                break;
            }
            case NORTH: {
                this.north(value);
                break;
            }
            case SOUTH: {
                this.south(value);
                break;
            }
            case WEST: {
                this.west(value);
                break;
            }
            case EAST: {
                this.east(value);
            }
        }
        return this;
    }

    public Box set(Direction direction, double value) {
        switch (direction) {
            case DOWN: {
                this.setDown(value);
                break;
            }
            case UP: {
                this.setUp(value);
                break;
            }
            case NORTH: {
                this.setNorth(value);
                break;
            }
            case SOUTH: {
                this.setSouth(value);
                break;
            }
            case WEST: {
                this.setWest(value);
                break;
            }
            case EAST: {
                this.setEast(value);
            }
        }
        return this;
    }

    public Box add(double value) {
        this.down(value);
        this.up(value);
        this.north(value);
        this.south(value);
        this.west(value);
        this.east(value);
        return this;
    }

    public Box set(double value) {
        this.setDown(value);
        this.setUp(value);
        this.setNorth(value);
        this.setSouth(value);
        this.setWest(value);
        this.setEast(value);
        return this;
    }

    public double getDown() {
        return this.down;
    }

    public Box down(double down) {
        this.setDown(this.down + down);
        return this;
    }

    public Box setDown(double down) {
        this.down = Math.min(this.max, Math.max(this.min, down));
        return this;
    }

    public double getUp() {
        return this.up;
    }

    public Box up(double up) {
        this.setUp(this.up + up);
        return this;
    }

    public Box setUp(double up) {
        this.up = Math.min(this.max, Math.max(this.min, up));
        return this;
    }

    public double getNorth() {
        return this.north;
    }

    public Box north(double north) {
        this.setNorth(this.north + north);
        return this;
    }

    public Box setNorth(double north) {
        this.north = Math.min(this.max, Math.max(this.min, north));
        return this;
    }

    public double getSouth() {
        return this.south;
    }

    public Box south(double south) {
        this.setSouth(this.south + south);
        return this;
    }

    public Box setSouth(double south) {
        this.south = Math.min(this.max, Math.max(this.min, south));
        return this;
    }

    public double getWest() {
        return this.west;
    }

    public Box west(double west) {
        this.setWest(this.west + west);
        return this;
    }

    public Box setWest(double west) {
        this.west = Math.min(this.max, Math.max(this.min, west));
        return this;
    }

    public double getEast() {
        return this.east;
    }

    public Box east(double east) {
        this.setEast(this.east + east);
        return this;
    }

    public Box setEast(double east) {
        this.east = Math.min(this.max, Math.max(this.min, east));
        return this;
    }
}

