/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.logistics.energy;

import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import owmii.lib.compat.curios.CuriosCompat;
import owmii.lib.item.EnergyBlockItem;
import owmii.lib.util.Player;
import owmii.lib.util.Stack;
import owmii.lib.util.Util;

public class Energy
implements IEnergyStorage {
    public static final Energy EMPTY = Energy.create(0L);
    public static final Long MAX = 9000000000000000000L;
    public static final Long MIN = 0L;
    private long capacity;
    private long stored;
    private long maxExtract;
    private long maxReceive;

    public Energy(Energy energy) {
        this(energy.capacity, energy.maxExtract, energy.maxReceive);
        this.setStored(energy.stored);
    }

    public Energy(long capacity, long maxExtract, long maxReceive) {
        this.capacity = capacity;
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public static Energy create(long capacity) {
        return Energy.create(capacity, capacity, capacity);
    }

    public static Energy create(long capacity, long transfer) {
        return Energy.create(capacity, transfer, transfer);
    }

    public static Energy from(Energy energy) {
        return new Energy(energy);
    }

    public static Energy create(long capacity, long maxExtract, long maxReceive) {
        return new Energy(capacity, maxExtract, maxReceive);
    }

    public boolean clone(Energy other) {
        boolean flag = false;
        if (this.capacity != other.capacity) {
            this.setCapacity(other.getCapacity());
            flag = true;
        }
        if (this.stored != other.stored) {
            this.setStored(other.getStored());
            flag = true;
        }
        if (this.getTransfer() != other.getTransfer()) {
            this.setTransfer(other.getTransfer());
            flag = true;
        }
        return flag;
    }

    public Energy read(CompoundNBT nbt, boolean capacity, boolean transfer) {
        return this.read(nbt, "main_energy", capacity, transfer);
    }

    public Energy read(CompoundNBT nbt, String key, boolean capacity, boolean transfer) {
        if (capacity) {
            this.capacity = nbt.func_74763_f("energy_capacity_" + key);
        }
        this.stored = nbt.func_74763_f("energy_stored_" + key);
        if (transfer) {
            this.maxExtract = nbt.func_74763_f("max_extract_" + key);
            this.maxReceive = nbt.func_74763_f("max_receive_" + key);
        }
        return this;
    }

    public CompoundNBT write(boolean capacity, boolean transfer) {
        return this.write("main_energy", capacity, transfer);
    }

    public CompoundNBT write(String key, boolean capacity, boolean transfer) {
        return this.write(new CompoundNBT(), key, capacity, transfer);
    }

    public CompoundNBT write(CompoundNBT nbt, boolean capacity, boolean transfer) {
        return this.write(nbt, "main_energy", capacity, transfer);
    }

    public CompoundNBT write(CompoundNBT nbt, String key, boolean capacity, boolean transfer) {
        if (capacity) {
            nbt.func_74772_a("energy_capacity_" + key, this.capacity);
        }
        nbt.func_74772_a("energy_stored_" + key, this.stored);
        if (transfer) {
            nbt.func_74772_a("max_extract_" + key, this.maxExtract);
            nbt.func_74772_a("max_receive_" + key, this.maxReceive);
        }
        return nbt;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        long received = Math.min(this.capacity - this.stored, Math.min(this.maxReceive, (long)maxReceive));
        if (!simulate) {
            this.produce(received);
        }
        return Util.safeInt(received);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        long extracted = Math.min(this.stored, Math.min(this.maxExtract, (long)maxExtract));
        if (!simulate) {
            this.consume(extracted);
        }
        return Util.safeInt(extracted);
    }

    public void addCapacity(long amount) {
        this.setCapacity(this.getCapacity() + amount);
    }

    public void removeCapacity(long amount) {
        this.setCapacity(this.getCapacity() - amount);
    }

    public long produce(long amount) {
        long min = Math.min(this.capacity - this.stored, Math.max(0L, amount));
        this.stored += min;
        return min;
    }

    public long consume(long amount) {
        long min = Math.min(this.stored, Math.max(0L, amount));
        this.stored -= min;
        return min;
    }

    public long chargeInventory(PlayerEntity player, Predicate<ItemStack> checker) {
        int received;
        long amount;
        long l = 0L;
        Iterator<ItemStack> iterator = Player.invStacks(player).iterator();
        while (iterator.hasNext()) {
            ItemStack stack1 = (ItemStack)iterator.next();
            if (stack1.func_190926_b() || !Energy.isPresent(stack1) || !checker.test(stack1)) continue;
            amount = Math.min(this.getMaxExtract(), (long)this.getEnergyStored());
            if (amount <= 0L) break;
            received = Energy.receive(stack1, amount, false);
            l += (long)this.extractEnergy(received, false);
        }
        if (CuriosCompat.isLoaded()) {
            for (ItemStack stack1 : CuriosCompat.getAllStacks(player)) {
                if (stack1.func_190926_b() || !Energy.isPresent(stack1) || !checker.test(stack1)) continue;
                amount = Math.min(this.getMaxExtract(), (long)this.getEnergyStored());
                if (amount <= 0L) break;
                received = Energy.receive(stack1, amount, false);
                l += (long)this.extractEnergy(received, false);
            }
        }
        return l;
    }

    public long getEmpty() {
        return this.getCapacity() - this.getStored();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public Energy setCapacity(long capacity) {
        this.capacity = Math.max(0L, Math.min(MAX, capacity));
        if (this.stored > this.capacity) {
            this.stored = this.capacity;
        }
        return this;
    }

    public Energy setAll(long value) {
        this.setCapacity(value);
        this.setTransfer(value);
        return this;
    }

    public long getStored() {
        return Math.min(this.stored, this.capacity);
    }

    public Energy setStored(long stored) {
        this.stored = Math.max(0L, Math.min(this.capacity, stored));
        return this;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public Energy setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public Energy setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public Energy setMaxTransfer() {
        this.maxReceive = MAX;
        this.maxExtract = MAX;
        return this;
    }

    public Energy setTransfer(long transfer) {
        this.maxReceive = transfer;
        this.maxExtract = transfer;
        return this;
    }

    public long getTransfer() {
        return Math.max(this.maxExtract, this.maxReceive);
    }

    public int getEnergyStored() {
        return Util.safeInt(this.stored);
    }

    public int getMaxEnergyStored() {
        return Util.safeInt(this.capacity);
    }

    public boolean canExtract() {
        return this.maxExtract > 0L && !this.isEmpty();
    }

    public boolean canReceive() {
        return this.maxReceive > 0L && !this.isFull();
    }

    public int toComparatorPower() {
        return (int)(this.subSized() * 15.0f);
    }

    public float subSized() {
        return this.capacity > 0L ? (float)this.stored / (float)this.capacity : 0.0f;
    }

    public boolean hasEnergy() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.stored <= 0L;
    }

    public boolean isFull() {
        return this.stored > 0L && this.stored >= this.capacity;
    }

    public long getPercent() {
        return (long)(this.subSized() * 100.0f);
    }

    public static int extract(ItemStack stack, long energy, boolean simulate) {
        return ((IEnergyStorage)Energy.get(stack).orElse((Object)EMPTY)).extractEnergy(Util.safeInt(energy), simulate);
    }

    public static int receive(ItemStack stack, long energy, boolean simulate) {
        return ((IEnergyStorage)Energy.get(stack).orElse((Object)EMPTY)).receiveEnergy(Util.safeInt(energy), simulate);
    }

    public static int getStored(ItemStack stack) {
        return ((IEnergyStorage)Energy.get(stack).orElse((Object)EMPTY)).getEnergyStored();
    }

    public static void ifPresent(ItemStack stack, NonNullConsumer<? super IEnergyStorage> consumer) {
        Energy.get(stack).ifPresent(consumer);
    }

    public static boolean chargeable(ItemStack stack) {
        EnergyBlockItem item;
        if (stack.func_77973_b() instanceof EnergyBlockItem && !(item = (EnergyBlockItem)stack.func_77973_b()).isChargeable(stack)) {
            return false;
        }
        return Energy.isPresent(stack);
    }

    public static boolean isPresent(ItemStack stack) {
        return Energy.get(stack).isPresent();
    }

    public static LazyOptional<IEnergyStorage> get(ItemStack stack) {
        return !stack.func_190926_b() ? stack.getCapability(CapabilityEnergy.ENERGY, null) : LazyOptional.empty();
    }

    public static int extract(@Nullable TileEntity tile, Direction direction, long energy, boolean simulate) {
        return tile == null ? 0 : ((IEnergyStorage)Energy.get(tile, direction).orElse((Object)EMPTY)).extractEnergy(Util.safeInt(energy), simulate);
    }

    public static int receive(@Nullable TileEntity tile, Direction direction, long energy, boolean simulate) {
        return tile == null ? 0 : ((IEnergyStorage)Energy.get(tile, direction).orElse((Object)EMPTY)).receiveEnergy(Util.safeInt(energy), simulate);
    }

    public static void ifPresent(@Nullable TileEntity tile, @Nullable Direction direction, NonNullConsumer<? super IEnergyStorage> consumer) {
        Energy.get(tile, direction).ifPresent(consumer);
    }

    public static boolean isPresent(@Nullable TileEntity tile, @Nullable Direction direction) {
        return Energy.get(tile, direction).isPresent();
    }

    public static LazyOptional<IEnergyStorage> get(@Nullable TileEntity tile, @Nullable Direction direction) {
        return tile == null ? LazyOptional.empty() : tile.getCapability(CapabilityEnergy.ENERGY, direction != null ? direction.func_176734_d() : null);
    }

    public static boolean canExtract(@Nullable TileEntity tile, @Nullable Direction direction) {
        return tile != null && ((IEnergyStorage)Energy.get(tile, direction).orElse((Object)EMPTY)).canExtract();
    }

    public static boolean canReceive(@Nullable TileEntity tile, @Nullable Direction direction) {
        return tile != null && ((IEnergyStorage)Energy.get(tile, direction).orElse((Object)EMPTY)).canReceive();
    }

    public static class Item
    extends Energy {
        private final ItemStack stack;

        public Item(ItemStack stack, Item energy) {
            super(energy);
            this.stack = stack;
        }

        public Item(ItemStack stack, long capacity, long maxExtract, long maxReceive) {
            super(capacity, maxExtract, maxReceive);
            this.stack = stack;
            this.read(Stack.getTagOrEmpty(stack).func_74775_l("lollipoptile_stack_nbt"), false, false);
        }

        @Override
        public int receiveEnergy(int maxReceive, boolean simulate) {
            int energy = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                this.write(this.stack.func_190925_c("lollipoptile_stack_nbt"), false, false);
            }
            return energy;
        }

        @Override
        public int extractEnergy(int maxExtract, boolean simulate) {
            int energy = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                this.write(this.stack.func_190925_c("lollipoptile_stack_nbt"), false, false);
            }
            return energy;
        }

        public static class Provider
        implements ICapabilityProvider {
            private final ItemStack stack;
            private final long capacity;
            private final long maxExtract;
            private final long maxReceive;

            public Provider(ItemStack stack, long capacity, long maxExtract, long maxReceive) {
                this.stack = stack;
                this.capacity = capacity;
                this.maxExtract = maxExtract;
                this.maxReceive = maxReceive;
            }

            public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                return cap == CapabilityEnergy.ENERGY ? LazyOptional.of(() -> new Item(this.stack, this.capacity, this.maxExtract, this.maxReceive)).cast() : LazyOptional.empty();
            }
        }
    }
}

