/*
 * Decompiled with CFR 0.152.
 */
package owmii.lib.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class CookingRecipeBuilder {
    private final ItemStack result;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final CookingRecipeSerializer<?> recipeSerializer;

    private CookingRecipeBuilder(ItemStack resultIn, Ingredient ingredientIn, float experienceIn, int cookingTimeIn, CookingRecipeSerializer<?> serializer) {
        this.result = resultIn;
        this.ingredient = ingredientIn;
        this.experience = experienceIn;
        this.cookingTime = cookingTimeIn;
        this.recipeSerializer = serializer;
    }

    public static CookingRecipeBuilder cookingRecipe(Ingredient ingredient, ItemStack result, float experience, int cookingTime, CookingRecipeSerializer<?> serializer) {
        return new CookingRecipeBuilder(result, ingredient, experience, cookingTime, serializer);
    }

    public static CookingRecipeBuilder blastingRecipe(Ingredient ingredient, ItemStack result, float experience, int cookingTime) {
        return CookingRecipeBuilder.cookingRecipe(ingredient, result, experience, cookingTime, IRecipeSerializer.field_222172_p);
    }

    public static CookingRecipeBuilder smeltingRecipe(Ingredient ingredient, ItemStack result, float experience, int cookingTime) {
        return CookingRecipeBuilder.cookingRecipe(ingredient, result, experience, cookingTime, IRecipeSerializer.field_222171_o);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn) {
        this.build(consumerIn, Registry.field_212630_s.func_177774_c((Object)this.result.func_77973_b()));
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, String save) {
        ResourceLocation location1 = new ResourceLocation(save);
        ResourceLocation location = Registry.field_212630_s.func_177774_c((Object)this.result.func_77973_b());
        if (location1.equals((Object)location)) {
            throw new IllegalStateException("Recipe " + location1 + " should remove its 'save' argument");
        }
        this.build(consumerIn, location1);
    }

    public void build(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.ingredient, this.result, this.experience, this.cookingTime, (IRecipeSerializer<? extends AbstractCookingRecipe>)this.recipeSerializer));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final ItemStack result;
        private final float experience;
        private final int cookingTime;
        private final IRecipeSerializer<? extends AbstractCookingRecipe> serializer;

        public Result(ResourceLocation idIn, Ingredient ingredientIn, ItemStack resultIn, float experienceIn, int cookingTimeIn, IRecipeSerializer<? extends AbstractCookingRecipe> serializerIn) {
            this.id = idIn;
            this.ingredient = ingredientIn;
            this.result = resultIn;
            this.experience = experienceIn;
            this.cookingTime = cookingTimeIn;
            this.serializer = serializerIn;
        }

        public void func_218610_a(JsonObject json) {
            json.add("ingredient", this.ingredient.func_200304_c());
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Registry.field_212630_s.func_177774_c((Object)this.result.func_77973_b()).toString());
            if (this.result.func_190916_E() > 1) {
                jsonObject.addProperty("count", (Number)this.result.func_190916_E());
            }
            json.add("result", (JsonElement)jsonObject);
            json.addProperty("experience", (Number)Float.valueOf(this.experience));
            json.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

