/*
 * Decompiled with CFR 0.152.
 */
package com.logprot.players;

import com.logprot.Logprot;
import com.logprot.Utils.BlockPosUtils;
import com.logprot.event.PlayerEventHandler;
import com.logprot.players.PlayerData;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

public class PlayerManager {
    private static PlayerManager instance;
    private boolean debug;
    private WeakHashMap<UUID, PlayerData> playerDataMap;

    private PlayerManager() {
        this.debug = (Boolean)Logprot.getConfig().getCommon().debugOutput.get();
        this.playerDataMap = new WeakHashMap();
    }

    public static PlayerManager getInstance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }

    public void onPlayerLogin(PlayerEntity player) {
        if (this.playerDataMap.containsKey(player.func_146103_bH().getId())) {
            return;
        }
        this.playerDataMap.put(player.func_146103_bH().getId(), new PlayerData(player, player.func_233580_cy_(), (Integer)Logprot.getConfig().getCommon().invulTime.get()));
        player.field_70737_aN = (Integer)Logprot.getConfig().getCommon().invulTime.get();
        if (this.debug) {
            Logprot.LOGGER.info("Player:" + player.hashCode() + " now has protection for " + Logprot.getConfig().getCommon().invulTime.get() + " ticks");
        }
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register((Object)PlayerEventHandler.getInstance());
    }

    public void updatePlayers() {
        if (this.playerDataMap.isEmpty()) {
            return;
        }
        double maxDist = Math.pow(((Integer)Logprot.getConfig().getCommon().maxDist.get()).intValue(), 2.0);
        Iterator<Map.Entry<UUID, PlayerData>> iterator = this.playerDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, PlayerData> entry = iterator.next();
            if (!((double)BlockPosUtils.dist2DSQ(entry.getValue().loginPos, entry.getValue().player.func_233580_cy_()) > maxDist) && entry.getValue().invulTime-- > 0) continue;
            if (this.debug) {
                Logprot.LOGGER.info("Player:" + entry.getKey().hashCode() + " got his protection removed");
            }
            entry.getValue().player.field_70737_aN = 0;
            iterator.remove();
        }
        if (this.playerDataMap.isEmpty()) {
            ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).unregister((Object)PlayerEventHandler.getInstance());
        }
    }

    public boolean isPlayerImmune(PlayerEntity playerEntity) {
        return this.playerDataMap.containsKey(playerEntity.func_146103_bH().getId());
    }
}

