/*
 * Decompiled with CFR 0.152.
 */
package com.ccr4ft3r.lightspeed.mixin.resources;

import com.ccr4ft3r.lightspeed.cache.GlobalCache;
import com.ccr4ft3r.lightspeed.interfaces.IPackResources;
import com.ccr4ft3r.lightspeed.interfaces.IPathResourcePack;
import com.ccr4ft3r.lightspeed.util.CacheUtil;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.packs.ModFileResourcePack;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.io.FilenameUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ModFileResourcePack.class})
public abstract class PathResourcePackMixin
implements IPathResourcePack,
IPackResources {
    @Shadow
    @Final
    private ModFile modFile;
    private final Map<ResourcePackType, Set<String>> namespacesByPackType = Maps.newConcurrentMap();
    private final Map<String, Path> inputPathByPath = Maps.newConcurrentMap();
    private final Map<ResourcePackType, Map<String, List<Path>>> filePathsByRootByPackType = PathResourcePackMixin.initPathsMap();
    private String id;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void initReturnInjected(ModFile modFile, CallbackInfo ci) {
        if (GlobalCache.isEnabled.booleanValue()) {
            GlobalCache.add(this);
        }
        this.id = ((IModInfo)modFile.getModFileInfo().getMods().get(0)).getModId() + ((IModInfo)modFile.getModFileInfo().getMods().get(0)).getVersion().toString() + "-" + FilenameUtils.getBaseName((String)modFile.getFilePath().toString()).replaceAll("[^a-zA-Z0-9.-]", "");
        this.setExistenceByResource(GlobalCache.PERSISTED_EXISTENCES_BY_MOD.computeIfAbsent(this.id, i -> Maps.newConcurrentMap()));
    }

    private static Map<ResourcePackType, Map<String, List<Path>>> initPathsMap() {
        ConcurrentMap map = Maps.newConcurrentMap();
        for (ResourcePackType packType : ResourcePackType.values()) {
            map.put(packType, Maps.newConcurrentMap());
        }
        return map;
    }

    @Inject(method={"getNamespaces"}, at={@At(value="HEAD")}, cancellable=true)
    public void getNamespacesHeadInjected(ResourcePackType type, CallbackInfoReturnable<Set<String>> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        Set<String> namespaces = this.getCachedNamespaces(type);
        if (namespaces != null) {
            cir.setReturnValue(namespaces);
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")})
    public void getNamespacesReturnInjected(ResourcePackType type, CallbackInfoReturnable<Set<String>> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        if (GlobalCache.shouldCacheEmptyNamespaces.booleanValue() || cir.getReturnValue() != null && !((Set)cir.getReturnValue()).isEmpty()) {
            this.cacheNamespaces(type, (Set)cir.getReturnValue());
        }
    }

    @Inject(method={"hasResource(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void hasResourceHeadInjected(String name, CallbackInfoReturnable<Boolean> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        Boolean exists = this.exists(name);
        if (exists != null) {
            cir.setReturnValue((Object)exists);
        }
    }

    @Inject(method={"hasResource(Ljava/lang/String;)Z"}, at={@At(value="RETURN")})
    public void hasResourceReturnInjected(String name, CallbackInfoReturnable<Boolean> cir) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        this.cacheExists(name, (Boolean)cir.getReturnValue());
    }

    @Inject(method={"getResources"}, at={@At(value="INVOKE", target="Ljava/nio/file/Path;getFileSystem()Ljava/nio/file/FileSystem;")}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    public synchronized void getResourcesInjected(ResourcePackType type, String resourceNamespace, String pathIn, int maxDepth, Predicate<String> filter, CallbackInfoReturnable<Collection<ResourceLocation>> cir, Path root) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return;
        }
        String resource = root.toString();
        Boolean exists = this.exists(resource);
        if (exists == null) {
            exists = Files.exists(root, new LinkOption[0]);
            this.cacheExists(resource, exists);
        }
        if (!exists.booleanValue()) {
            cir.setReturnValue(Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"getResources"}, at=@At(value="INVOKE", target="Ljava/nio/file/Files;walk(Ljava/nio/file/Path;[Ljava/nio/file/FileVisitOption;)Ljava/util/stream/Stream;"))
    public synchronized Stream<Path> getResourcesWalkInjected(Path start, FileVisitOption[] options, ResourcePackType type, String resourceNamespace) throws IOException {
        if (!GlobalCache.isEnabled.booleanValue() || !GlobalCache.shouldCacheWalkedPaths.booleanValue()) {
            return Files.walk(start, new FileVisitOption[0]);
        }
        List<Path> paths = this.getFilePaths(type, resourceNamespace);
        if (paths == null) {
            try {
                try (Stream<Path> pathStream = Files.walk(start, new FileVisitOption[0]);){
                    paths = pathStream.collect(Collectors.toList());
                }
                this.cacheFilePaths(type, resourceNamespace, paths == null ? Collections.emptyList() : paths);
            }
            catch (Throwable throwable) {
                this.cacheFilePaths(type, resourceNamespace, paths == null ? Collections.emptyList() : paths);
                throw throwable;
            }
        }
        return paths.parallelStream();
    }

    @Redirect(method={"getResources"}, at=@At(value="INVOKE", target="Ljava/nio/file/FileSystem;getPath(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;"))
    public Path getResourcesGetPathRedirected(FileSystem instance, String s, String[] strings) {
        if (!GlobalCache.isEnabled.booleanValue()) {
            return instance.getPath(s, new String[0]);
        }
        Path inputPath = this.inputPathByPath.get(s);
        if (inputPath == null) {
            inputPath = instance.getPath(s, new String[0]);
            this.inputPathByPath.put(s, inputPath);
        }
        return inputPath;
    }

    @Override
    public void persistAndClearCache() {
        if (this.modFile != null) {
            CacheUtil.persist(this.getExistenceByResource(), new File(CacheUtil.HAS_RESOURCE_CACHE_DIR.getPath(), this.id + ".ser"));
            CacheUtil.persist(this.namespacesByPackType, new File(CacheUtil.NAMESPACE_CACHE_DIR.getPath(), this.id + ".ser"));
        }
        this.getExistenceByResource().clear();
        this.namespacesByPackType.clear();
        this.filePathsByRootByPackType.clear();
    }

    public Boolean exists(String resourceName) {
        return (Boolean)this.getExistenceByResource().get(resourceName);
    }

    public void cacheExists(String resourceName, boolean exists) {
        this.getExistenceByResource().put(resourceName, exists);
    }

    public void cacheFilePaths(ResourcePackType packType, String resourceNamespace, List<Path> filePaths) {
        this.getFilePathsMap(packType).putIfAbsent(resourceNamespace, filePaths);
    }

    public List<Path> getFilePaths(ResourcePackType packType, String resourceNamespace) {
        return this.getFilePathsMap(packType).get(resourceNamespace);
    }

    private Map<String, List<Path>> getFilePathsMap(ResourcePackType packType) {
        return this.filePathsByRootByPackType.get(packType);
    }

    public void cacheNamespaces(ResourcePackType packType, Set<String> namespaces) {
        this.namespacesByPackType.put(packType, namespaces);
    }

    public Set<String> getCachedNamespaces(ResourcePackType packType) {
        return this.namespacesByPackType.get(packType);
    }
}

