/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.util;

import java.util.function.BiConsumer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class TextComponentUtil {
    public static String getConsoleString(ITextComponent tc) {
        StringBuilder sb = new StringBuilder();
        TextComponentUtil.traverseComponent((ITextProperties)tc, Style.field_240709_b_, (string, style) -> {
            TextComponentUtil.reset(sb);
            TextComponentUtil.formattingCodes(sb, style);
            sb.append((String)string);
        });
        TextComponentUtil.reset(sb);
        return sb.toString();
    }

    private static void formattingCodes(StringBuilder sb, Style style) {
        if (style.func_240711_a_() != null) {
            int color = style.func_240711_a_().field_240740_c_;
            sb.append("\u001b[38;2;").append(color >> 16 & 0xFF).append(";").append(color >> 8 & 0xFF).append(";").append(color & 0xFF).append("m");
        }
        if (style.field_150248_c != null) {
            if (style.field_150248_c.booleanValue()) {
                sb.append("\u001b[1m");
            } else {
                sb.append("\u001b[22m");
            }
        }
        if (style.field_150245_d != null) {
            if (style.field_150245_d.booleanValue()) {
                sb.append("\u001b[3m");
            } else {
                sb.append("\u001b[23m");
            }
        }
        if (style.field_150246_e != null) {
            if (style.field_150246_e.booleanValue()) {
                sb.append("\u001b[4m");
            } else {
                sb.append("\u001b[24m");
            }
        }
        if (style.field_150243_f != null) {
            if (style.field_150243_f.booleanValue()) {
                sb.append("\u001b[9m");
            } else {
                sb.append("\u001b[29m");
            }
        }
        if (style.field_150244_g != null) {
            if (style.field_150244_g.booleanValue()) {
                sb.append("\u001b[8m");
            } else {
                sb.append("\u001b[28m");
            }
        }
    }

    private static void reset(StringBuilder sb) {
        sb.append("\u001b[0m");
    }

    private static void traverseComponent(ITextProperties tc, Style parent, BiConsumer<String, Style> consumer) {
        Style style = tc instanceof ITextComponent ? ((ITextComponent)tc).func_150256_b().func_240717_a_(parent) : parent;
        TextComponentUtil.consumeComponent(tc, style, consumer);
        if (tc instanceof ITextComponent) {
            for (ITextComponent sibling : ((ITextComponent)tc).func_150253_a()) {
                TextComponentUtil.traverseComponent((ITextProperties)sibling, style, consumer);
            }
        }
    }

    private static void consumeComponent(ITextProperties tc, Style style, BiConsumer<String, Style> consumer) {
        if (tc instanceof TranslationTextComponent) {
            ((TranslationTextComponent)tc).func_150270_g();
            for (ITextProperties child : ((TranslationTextComponent)tc).field_150278_b) {
                TextComponentUtil.traverseComponent(child, style, consumer);
            }
        } else if (tc instanceof KeybindTextComponent) {
            TextComponentUtil.traverseComponent((ITextProperties)((KeybindTextComponent)tc).func_240698_i_(), style, consumer);
        } else if (tc instanceof ITextComponent) {
            consumer.accept(((ITextComponent)tc).func_150261_e(), style);
        } else {
            consumer.accept(tc.getString(), style);
        }
    }
}

