/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class RenderHelperBlock {
    private static final RenderType RENDER_TYPE_BREAK = RenderType.func_228656_k_((ResourceLocation)PlayerContainer.field_226615_c_);
    private static final Random random = new Random();

    public static void renderBlockBreak(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, int breakProgress) {
        RenderHelperBlock.renderBlockBreak(state, matrixStack, buffer, light, overlay, breakProgress, state.func_209533_a(BlockPos.field_177992_a));
    }

    public static void renderBlockBreak(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, int breakProgress, long positionRandom) {
        if (breakProgress > 0) {
            ResourceLocation tex = (ResourceLocation)ModelBakery.field_229318_i_.get((breakProgress - 1) % ModelBakery.field_229318_i_.size());
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(tex);
            RenderHelperBlock.renderBlockOverlaySprite(state, matrixStack, buffer, light, overlay, sprite, positionRandom);
        }
    }

    public static void renderBlockOverlaySprite(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, TextureAtlasSprite sprite) {
        RenderHelperBlock.renderBlockOverlaySprite(state, matrixStack, buffer, light, overlay, sprite, state.func_209533_a(BlockPos.field_177992_a));
    }

    public static void renderBlockOverlaySprite(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, TextureAtlasSprite sprite, long positionRandom) {
        RenderHelperBlock.renderBlockOverlaySprite(state, matrixStack, buffer, light, overlay, sprite, positionRandom, dir -> true);
    }

    public static void renderBlockOverlaySprite(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, TextureAtlasSprite sprite, Predicate<Direction> dirs) {
        RenderHelperBlock.renderBlockOverlaySprite(state, matrixStack, buffer, light, overlay, sprite, state.func_209533_a(BlockPos.field_177992_a), dirs);
    }

    public static void renderBlockOverlaySprite(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, TextureAtlasSprite sprite, long positionRandom, Predicate<Direction> dirs) {
        if (state.func_185901_i() == BlockRenderType.MODEL) {
            IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state);
            IVertexBuilder vertex = Minecraft.func_71410_x().func_228019_au_().func_228489_c_().getBuffer(RENDER_TYPE_BREAK);
            for (Direction direction : Direction.values()) {
                random.setSeed(positionRandom);
                List list = model.getQuads(state, direction, random, (IModelData)EmptyModelData.INSTANCE);
                if (list.isEmpty()) continue;
                RenderHelperBlock.renderBlockBreakQuad(matrixStack.func_227866_c_(), vertex, list, light, overlay, sprite, dirs);
            }
            random.setSeed(positionRandom);
            List list = model.getQuads(state, null, random, (IModelData)EmptyModelData.INSTANCE);
            if (!list.isEmpty()) {
                RenderHelperBlock.renderBlockBreakQuad(matrixStack.func_227866_c_(), vertex, list, light, overlay, sprite, dirs);
            }
        }
    }

    private static void renderBlockBreakQuad(MatrixStack.Entry matrix, IVertexBuilder vertex, List<BakedQuad> list, int light, int overlay, TextureAtlasSprite sprite, Predicate<Direction> dirs) {
        for (BakedQuad quad : list) {
            if (!dirs.test(quad.func_178210_d())) continue;
            BakedQuad modifiedQuad = new BakedQuad(RenderHelperBlock.modifyBlockBreakQuadData(quad.func_178209_a(), quad.func_187508_a(), sprite), quad.func_178211_c(), quad.func_178210_d(), sprite, quad.func_239287_f_());
            vertex.func_227889_a_(matrix, modifiedQuad, 1.0f, 1.0f, 1.0f, light, overlay);
        }
    }

    private static int[] modifyBlockBreakQuadData(int[] data, TextureAtlasSprite oldSprite, TextureAtlasSprite newSprite) {
        int[] newData = new int[data.length];
        System.arraycopy(data, 0, newData, 0, data.length);
        int off = 0;
        while (off + 7 < newData.length) {
            newData[off + 4] = Float.floatToRawIntBits((Float.intBitsToFloat(data[off + 4]) - oldSprite.func_94209_e()) * (float)newSprite.func_94211_a() / (float)oldSprite.func_94211_a() + newSprite.func_94209_e());
            newData[off + 5] = Float.floatToRawIntBits((Float.intBitsToFloat(data[off + 5]) - oldSprite.func_94206_g()) * (float)newSprite.func_94216_b() / (float)oldSprite.func_94216_b() + newSprite.func_94206_g());
            off += DefaultVertexFormats.field_176600_a.func_181719_f();
        }
        return newData;
    }
}

