/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.inventory;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemStackHandlerWrapper
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable inventory;
    private final BiFunction<Integer, ItemStack, Boolean> canInsert;
    private final Function<Integer, Boolean> canExtract;

    public ItemStackHandlerWrapper(IItemHandlerModifiable inventory, @Nullable Function<Integer, Boolean> canExtract, @Nullable BiFunction<Integer, ItemStack, Boolean> canInsert) {
        this.inventory = inventory;
        this.canExtract = canExtract;
        this.canInsert = canInsert;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.inventory.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        return this.inventory.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canExtract != null && !this.canExtract.apply(slot).booleanValue()) {
            return ItemStack.field_190927_a;
        }
        return this.inventory.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.inventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.canInsert == null || this.canInsert.apply(slot, stack) != false;
    }

    public static LazyOptional<IItemHandlerModifiable> create(IItemHandlerModifiable inv) {
        return LazyOptional.of(() -> new ItemStackHandlerWrapper(inv, null, null));
    }

    public static LazyOptional<IItemHandlerModifiable> create(IItemHandlerModifiable inv, @Nullable Function<Integer, Boolean> canExtract, @Nullable BiFunction<Integer, ItemStack, Boolean> canInsert) {
        return LazyOptional.of(() -> new ItemStackHandlerWrapper(inv, canExtract, canInsert));
    }

    public static LazyOptional<IItemHandlerModifiable> createLazy(Supplier<IItemHandlerModifiable> inv) {
        return LazyOptional.of(() -> new ItemStackHandlerWrapper((IItemHandlerModifiable)inv.get(), null, null));
    }

    public static LazyOptional<IItemHandlerModifiable> createLazy(Supplier<IItemHandlerModifiable> inv, @Nullable Function<Integer, Boolean> canExtract, @Nullable BiFunction<Integer, ItemStack, Boolean> canInsert) {
        return LazyOptional.of(() -> new ItemStackHandlerWrapper((IItemHandlerModifiable)inv.get(), canExtract, canInsert));
    }
}

