/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.impl.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.noeppi_noeppi.libx.config.ValueMapper;
import io.github.noeppi_noeppi.libx.crafting.IngredientStack;
import io.github.noeppi_noeppi.libx.util.ResourceList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class AdvancedValueMappers {
    public static final ValueMapper<Ingredient, JsonElement> INGREDIENT = new ValueMapper<Ingredient, JsonElement>(){

        @Override
        public Class<Ingredient> type() {
            return Ingredient.class;
        }

        @Override
        public Class<JsonElement> element() {
            return JsonElement.class;
        }

        @Override
        public Ingredient fromJSON(JsonElement json, Class<?> elementType) {
            return Ingredient.func_199802_a((JsonElement)json);
        }

        @Override
        public JsonElement toJSON(Ingredient value, Class<?> elementType) {
            return value.func_200304_c();
        }

        @Override
        public Ingredient read(PacketBuffer buffer, Class<?> elementType) {
            return Ingredient.func_199566_b((PacketBuffer)buffer);
        }

        @Override
        public void write(Ingredient value, PacketBuffer buffer, Class<?> elementType) {
            value.func_199564_a(buffer);
        }
    };
    public static final ValueMapper<IFormattableTextComponent, JsonElement> TEXT_COMPONENT = new ValueMapper<IFormattableTextComponent, JsonElement>(){

        @Override
        public Class<IFormattableTextComponent> type() {
            return IFormattableTextComponent.class;
        }

        @Override
        public Class<JsonElement> element() {
            return JsonElement.class;
        }

        @Override
        public IFormattableTextComponent fromJSON(JsonElement json, Class<?> elementType) {
            return ITextComponent.Serializer.func_240641_a_((JsonElement)json);
        }

        @Override
        public JsonElement toJSON(IFormattableTextComponent value, Class<?> elementType) {
            return ITextComponent.Serializer.func_200528_b((ITextComponent)value);
        }
    };
    public static final ValueMapper<ResourceLocation, JsonPrimitive> RESOURCE = new ValueMapper<ResourceLocation, JsonPrimitive>(){

        @Override
        public Class<ResourceLocation> type() {
            return ResourceLocation.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public ResourceLocation fromJSON(JsonPrimitive json, Class<?> elementType) {
            return new ResourceLocation(json.getAsString());
        }

        @Override
        public JsonPrimitive toJSON(ResourceLocation value, Class<?> elementType) {
            return new JsonPrimitive(value.toString());
        }

        @Override
        public ResourceLocation read(PacketBuffer buffer, Class<?> elementType) {
            return buffer.func_192575_l();
        }

        @Override
        public void write(ResourceLocation value, PacketBuffer buffer, Class<?> elementType) {
            buffer.func_192572_a(value);
        }
    };
    public static final ValueMapper<ResourceList, JsonObject> RESOURCE_LIST = new ValueMapper<ResourceList, JsonObject>(){
        private final List<String> COMMENT = ImmutableList.of((Object)"This is a resource list. In the `whitelist` field you can specify whether all entries will be accepted by", (Object)"default or rejected.", (Object)"`elements` is an array of rules. Each resource location that is matched against this list, will traverse these", (Object)"rules from top to bottom. The first rule that matches a resource location determines its result.", (Object)"Rules are resource locations, where asterisks (*) can be added to match any number of characters.", (Object)"However an asterisk can not match a colon. The nly exception to this is the single asterisk which matches everything.", (Object)"When a rule is matched, it will yield the result specified in `whitelist` as a result. To alter this", (Object)"add a plus (+) or a minus (-) in front of the rule. This will make it a whitelist or blacklist rule respectively.", (Object)"You can also add regex rules. These are objects with two keys: `allow` - a boolean that specifies whether this", (Object)"is a whitelist or blacklist rule and `regex` - which is a regex that must match the resource location.");

        @Override
        public Class<ResourceList> type() {
            return ResourceList.class;
        }

        @Override
        public Class<JsonObject> element() {
            return JsonObject.class;
        }

        @Override
        public ResourceList fromJSON(JsonObject json, Class<?> elementType) {
            return new ResourceList(json);
        }

        @Override
        public JsonObject toJSON(ResourceList value, Class<?> elementType) {
            return value.toJSON();
        }

        @Override
        public ResourceList read(PacketBuffer buffer, Class<?> elementType) {
            return new ResourceList(buffer);
        }

        @Override
        public void write(ResourceList value, PacketBuffer buffer, Class<?> elementType) {
            value.write(buffer);
        }

        @Override
        public List<String> comment(Class<?> elementType) {
            return this.COMMENT;
        }
    };
    public static final ValueMapper<IngredientStack, JsonObject> INGREDIENT_STACK = new ValueMapper<IngredientStack, JsonObject>(){

        @Override
        public Class<IngredientStack> type() {
            return IngredientStack.class;
        }

        @Override
        public Class<JsonObject> element() {
            return JsonObject.class;
        }

        @Override
        public IngredientStack fromJSON(JsonObject json, Class<?> elementType) {
            return IngredientStack.deserialize(json);
        }

        @Override
        public JsonObject toJSON(IngredientStack value, Class<?> elementType) {
            return value.serialize();
        }

        @Override
        public IngredientStack read(PacketBuffer buffer, Class<?> elementType) {
            return IngredientStack.read(buffer);
        }

        @Override
        public void write(IngredientStack value, PacketBuffer buffer, Class<?> elementType) {
            value.write(buffer);
        }
    };
    public static final ValueMapper<UUID, JsonPrimitive> UID = new ValueMapper<UUID, JsonPrimitive>(){

        @Override
        public Class<UUID> type() {
            return UUID.class;
        }

        @Override
        public Class<JsonPrimitive> element() {
            return JsonPrimitive.class;
        }

        @Override
        public UUID fromJSON(JsonPrimitive json, Class<?> elementType) {
            return UUID.fromString(json.getAsString());
        }

        @Override
        public JsonPrimitive toJSON(UUID value, Class<?> elementType) {
            return new JsonPrimitive(value.toString());
        }

        @Override
        public UUID read(PacketBuffer buffer, Class<?> elementType) {
            long mostSignificantBits = buffer.readLong();
            long leastSignificantBits = buffer.readLong();
            return new UUID(mostSignificantBits, leastSignificantBits);
        }

        @Override
        public void write(UUID value, PacketBuffer buffer, Class<?> elementType) {
            buffer.writeLong(value.getMostSignificantBits());
            buffer.writeLong(value.getLeastSignificantBits());
        }
    };
}

