/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.crafting.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionIngredient
extends Ingredient {
    public final Item potionItem;
    public final Potion potion;

    public PotionIngredient(Item potionItem, Potion potion) {
        super(Stream.empty());
        this.potionItem = potionItem;
        this.potion = potion;
    }

    @Nonnull
    public ItemStack[] func_193365_a() {
        ItemStack stack = new ItemStack((IItemProvider)this.potionItem);
        PotionUtils.func_185188_a((ItemStack)stack, (Potion)this.potion);
        return new ItemStack[]{stack};
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.func_190926_b() || stack.func_77973_b() != this.potionItem) {
            return false;
        }
        Potion itemPotion = PotionUtils.func_185191_c((ItemStack)stack);
        return itemPotion == this.potion;
    }

    @Nonnull
    public IntList func_194139_b() {
        ItemStack[] stacks = this.func_193365_a();
        IntArrayList ial = new IntArrayList(stacks.length);
        for (ItemStack stack : stacks) {
            ial.add(RecipeItemHelper.func_194113_b((ItemStack)stack));
        }
        return ial;
    }

    protected void invalidate() {
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public boolean func_203189_d() {
        return this.potionItem == Items.field_190931_a;
    }

    @Nonnull
    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)Serializer.INSTANCE).toString());
        json.addProperty("item", this.potionItem.getRegistryName().toString());
        json.addProperty("potion", this.potion.getRegistryName().toString());
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<PotionIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Nonnull
        public PotionIngredient parse(@Nonnull PacketBuffer buffer) {
            Potion potion;
            Item potionItem = (Item)ForgeRegistries.ITEMS.getValue(buffer.func_192575_l());
            if (potionItem == null) {
                potionItem = Items.field_190931_a;
            }
            if ((potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation(buffer.func_218666_n()))) == null) {
                potion = Potions.field_185229_a;
            }
            return new PotionIngredient(potionItem, potion);
        }

        @Nonnull
        public PotionIngredient parse(JsonObject json) {
            Potion potion;
            Item potionItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("item").getAsString()));
            if (potionItem == null) {
                potionItem = Items.field_190931_a;
            }
            if ((potion = (Potion)ForgeRegistries.POTION_TYPES.getValue(new ResourceLocation(json.get("potion").getAsString()))) == null) {
                potion = Potions.field_185229_a;
            }
            return new PotionIngredient(potionItem, potion);
        }

        public void write(@Nonnull PacketBuffer buffer, @Nonnull PotionIngredient ingredient) {
            buffer.func_192572_a(ingredient.potionItem.getRegistryName());
            buffer.func_192572_a(ingredient.potion.getRegistryName());
        }
    }
}

