/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import dev.rlnt.lazierae2.util.TypeEnums;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public class IOUtil {
    private static final Map<Integer, TypeEnums.IO_SIDE> IO_SIDE_MAP = new HashMap<Integer, TypeEnums.IO_SIDE>();
    private static final BiMap<Integer, TypeEnums.IO_SETTING> IO_SETTINGS_MAP = HashBiMap.create((int)TypeEnums.IO_SETTING.values().length);
    private static final EnumMap<TypeEnums.IO_SIDE, String> IO_SIDE_TRANSLATIONS = new EnumMap(TypeEnums.IO_SIDE.class);
    private static final EnumMap<TypeEnums.IO_SETTING, String> IO_SETTINGS_TRANSLATIONS = new EnumMap(TypeEnums.IO_SETTING.class);

    private IOUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Map<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> getSideConfigFromArray(int[] ioSettings) {
        EnumMap<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> config = new EnumMap<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING>(TypeEnums.IO_SIDE.class);
        for (int i = 0; i < ioSettings.length; ++i) {
            TypeEnums.IO_SIDE side = IO_SIDE_MAP.get(i + 1);
            TypeEnums.IO_SETTING setting = (TypeEnums.IO_SETTING)((Object)IO_SETTINGS_MAP.get((Object)ioSettings[i]));
            config.put(side, setting);
        }
        return config;
    }

    public static int[] serializeSideConfig(Map<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> sideConfig) {
        int[] ioSettings = new int[sideConfig.size()];
        int[] i = new int[]{0};
        sideConfig.values().forEach(setting -> {
            ioSettings[i[0]] = (Integer)IOUtil.getIOSettingsMap().inverse().get((Object)setting);
            i[0] = i[0] + 1;
        });
        return ioSettings;
    }

    public static boolean isChanged(Map<TypeEnums.IO_SIDE, TypeEnums.IO_SETTING> sideConfig) {
        int[] converted = IOUtil.serializeSideConfig(sideConfig);
        int[] unchanged = new int[]{0, 0, 0, 0, 0, 0};
        return !Arrays.equals(converted, unchanged);
    }

    public static BiMap<Integer, TypeEnums.IO_SETTING> getIOSettingsMap() {
        return IO_SETTINGS_MAP;
    }

    static Map<TypeEnums.IO_SETTING, String> getIoSettingsTranslations() {
        return IO_SETTINGS_TRANSLATIONS;
    }

    static EnumMap<TypeEnums.IO_SIDE, String> getIoSideTranslations() {
        return IO_SIDE_TRANSLATIONS;
    }

    static {
        TypeEnums.IO_SIDE[] sides = TypeEnums.IO_SIDE.values();
        for (int i = 0; i < sides.length; ++i) {
            IO_SIDE_MAP.put(i + 1, sides[i]);
        }
        TypeEnums.IO_SETTING[] ioSettings = TypeEnums.IO_SETTING.values();
        for (int i = 0; i < ioSettings.length; ++i) {
            IO_SETTINGS_MAP.put((Object)i, (Object)ioSettings[i]);
        }
        IO_SIDE_TRANSLATIONS.put(TypeEnums.IO_SIDE.TOP, "top");
        IO_SIDE_TRANSLATIONS.put(TypeEnums.IO_SIDE.LEFT, "left");
        IO_SIDE_TRANSLATIONS.put(TypeEnums.IO_SIDE.FRONT, "front");
        IO_SIDE_TRANSLATIONS.put(TypeEnums.IO_SIDE.RIGHT, "right");
        IO_SIDE_TRANSLATIONS.put(TypeEnums.IO_SIDE.BOTTOM, "bottom");
        IO_SIDE_TRANSLATIONS.put(TypeEnums.IO_SIDE.BACK, "back");
        IO_SETTINGS_TRANSLATIONS.put(TypeEnums.IO_SETTING.NONE, "none");
        IO_SETTINGS_TRANSLATIONS.put(TypeEnums.IO_SETTING.INPUT, "input");
        IO_SETTINGS_TRANSLATIONS.put(TypeEnums.IO_SETTING.OUTPUT, "output");
        IO_SETTINGS_TRANSLATIONS.put(TypeEnums.IO_SETTING.IO, "io");
    }
}

