/*
 * Decompiled with CFR 0.152.
 */
package dev.rlnt.lazierae2.data.client;

import dev.rlnt.lazierae2.setup.ModBlocks;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class BlockStates
extends BlockStateProvider {
    private static final String MACHINE_BLOCK_TEXTURE = "block/machine";

    public BlockStates(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "lazierae2", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerMachine(ModBlocks.AGGREGATOR);
        this.registerMachine(ModBlocks.CENTRIFUGE);
        this.registerMachine(ModBlocks.ENERGIZER);
        this.registerMachine(ModBlocks.ETCHER);
    }

    private void registerMachine(RegistryObject<Block> machine) {
        String name = Objects.requireNonNull(((Block)machine.get()).getRegistryName()).toString().substring("lazierae2".length() + 1);
        ResourceLocation mainRL = new ResourceLocation("lazierae2", MACHINE_BLOCK_TEXTURE);
        ResourceLocation frontRL = new ResourceLocation("lazierae2", "block/" + name);
        ResourceLocation frontRLActive = new ResourceLocation("lazierae2", "block/" + name + "_active");
        BlockModelBuilder modelMachine = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(name, mainRL, mainRL, frontRL, mainRL, mainRL, mainRL)).texture("particle", this.modLoc(MACHINE_BLOCK_TEXTURE));
        BlockModelBuilder modelMachineActive = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(name + "_active", mainRL, mainRL, frontRLActive, mainRL, mainRL, mainRL)).texture("particle", this.modLoc(MACHINE_BLOCK_TEXTURE));
        this.orientedBlock((Block)machine.get(), state -> {
            if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).equals(Boolean.TRUE)) {
                return modelMachineActive;
            }
            return modelMachine;
        });
    }

    private void orientedBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationX(dir.func_176740_k() == Direction.Axis.Y ? dir.func_176743_c().func_179524_a() * -90 : 0).rotationY(dir.func_176740_k() != Direction.Axis.Y ? (dir.func_176736_b() + 2) % 4 * 90 : 0).build();
        });
    }
}

