/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.thermal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.thermal.ThermalRecipeJS;
import dev.latvian.kubejs.util.ListJS;
import java.util.ArrayList;

public class FuelRecipeJS
extends ThermalRecipeJS {
    public ArrayList<FluidStackJS> inputFluids = new ArrayList();
    public String inKey = "";

    public void create(ListJS args) {
        this.inKey = "ingredients";
        for (Object o : ListJS.orSelf((Object)args.get(0))) {
            if (o instanceof FluidStackJS) {
                this.inputFluids.add((FluidStackJS)o);
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(o));
        }
        this.json.addProperty("energy", (Number)100000);
        if (this.inputItems.isEmpty() && this.inputFluids.isEmpty()) {
            throw new RecipeExceptionJS("Thermal recipe can't have no ingredients!");
        }
    }

    public void deserialize() {
        JsonElement element;
        this.inKey = "";
        if (this.json.has("ingredient")) {
            this.inKey = "ingredient";
        } else if (this.json.has("ingredients")) {
            this.inKey = "ingredients";
        } else if (this.json.has("input")) {
            this.inKey = "input";
        } else if (this.json.has("inputs")) {
            this.inKey = "inputs";
        }
        if (!this.inKey.isEmpty() && (element = this.json.get(this.inKey)) != null) {
            JsonArray array;
            if (element.isJsonArray()) {
                array = element.getAsJsonArray();
            } else {
                array = new JsonArray();
                array.add(element);
            }
            for (JsonElement e : array) {
                if (e.isJsonObject() && e.getAsJsonObject().has("fluid")) {
                    this.inputFluids.add(FluidStackJS.fromJson((JsonElement)e.getAsJsonObject()));
                    continue;
                }
                this.inputItems.add(this.parseIngredientItem(e));
            }
        }
    }

    public void serialize() {
        if (this.serializeInputs) {
            JsonArray in = new JsonArray();
            for (IngredientJS ingredient : this.inputItems) {
                in.add(ingredient.toJson());
            }
            for (FluidStackJS fluid : this.inputFluids) {
                in.add((JsonElement)fluid.toJson());
            }
            this.json.add(this.inKey, (JsonElement)in);
        }
    }
}

