/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.mekanism;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.mekanism.MekanismRecipeJS;
import dev.latvian.kubejs.util.ListJS;

public class MetallurgicInfusingRecipeJS
extends MekanismRecipeJS {
    public String infusionTag = "mekanism:redstone";
    public int infusionAmount = 10;

    public void create(ListJS args) {
        this.outputItems.add(this.parseResultItem(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)).asIngredientStack());
        if (args.size() >= 3) {
            this.infusionTag = args.get(2).toString();
            if (args.size() >= 4) {
                this.infusionAmount = ((Number)args.get(3)).intValue();
            }
        }
    }

    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("output")));
        this.inputItems.add(this.parseIngredientItem(this.json.get("itemInput")).asIngredientStack());
        if (this.json.has("infusionInput")) {
            JsonObject o = this.json.get("infusionInput").getAsJsonObject();
            if (o.has("tag")) {
                this.infusionTag = o.get("tag").getAsString();
            }
            if (o.has("amount")) {
                this.infusionAmount = o.get("amount").getAsInt();
            }
        }
    }

    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("output", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
        }
        if (this.serializeInputs) {
            this.json.add("itemInput", ((IngredientJS)this.inputItems.get(0)).toJson());
            JsonObject o = new JsonObject();
            o.addProperty("tag", this.infusionTag);
            o.addProperty("amount", (Number)this.infusionAmount);
            this.json.add("infusionInput", (JsonElement)o);
        }
    }
}

