/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.kubejs.player.AttachPlayerDataEvent;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.player.FakeServerPlayerDataJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.world.WorldCommandSender;
import dev.latvian.kubejs.world.WorldJS;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntitySelectorParser;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;

public class ServerWorldJS
extends WorldJS {
    private final ServerJS server;
    public final CompoundNBT persistentData;

    public ServerWorldJS(ServerJS s, ServerWorld w) {
        super((World)w);
        this.server = s;
        String t = w.func_234923_W_().func_240901_a_().toString();
        this.persistentData = s.persistentData.func_74775_l(t);
        s.persistentData.func_218657_a(t, (INBT)this.persistentData);
    }

    @Override
    public ScriptType getSide() {
        return ScriptType.SERVER;
    }

    @Override
    public ServerJS getServer() {
        return this.server;
    }

    public long getSeed() {
        return ((ServerWorld)this.minecraftLevel).func_72905_C();
    }

    public void setTime(long time) {
        ((IServerWorldInfo)this.minecraftLevel.func_72912_H()).func_82572_b(time);
    }

    public void setLocalTime(long time) {
        ((IServerWorldInfo)this.minecraftLevel.func_72912_H()).func_76068_b(time);
    }

    @Override
    public ServerPlayerDataJS getPlayerData(PlayerEntity player) {
        ServerPlayerDataJS data = this.server.playerMap.get(player.func_110124_au());
        if (data != null) {
            return data;
        }
        FakeServerPlayerDataJS fakeData = this.server.fakePlayerMap.get(player.func_110124_au());
        if (fakeData == null) {
            fakeData = new FakeServerPlayerDataJS(this.server, (ServerPlayerEntity)player);
            new AttachPlayerDataEvent(fakeData).invoke();
        }
        fakeData.player = (ServerPlayerEntity)player;
        return fakeData;
    }

    public String toString() {
        return "ServerWorld:" + this.getDimension();
    }

    @Override
    public EntityArrayList getEntities() {
        return new EntityArrayList((WorldJS)this, Lists.newArrayList((Iterable)((ServerWorld)this.minecraftLevel).func_241136_z_()));
    }

    public EntityArrayList getEntities(String filter) {
        if (filter.equals("@e")) {
            return this.getEntities();
        }
        if (filter.equals("@a")) {
            return this.getPlayers();
        }
        try {
            return this.createEntityList(new EntitySelectorParser(new StringReader(filter), true).func_201345_m().func_197341_b((CommandSource)new WorldCommandSender(this)));
        }
        catch (CommandSyntaxException e) {
            return new EntityArrayList((WorldJS)this, 0);
        }
    }
}

