/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.special;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.latvian.kubejs.recipe.KubeJSRecipeEventHandler;
import dev.latvian.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import me.shedaniel.architectury.core.AbstractRecipeSerializer;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShapedKubeJSRecipe
extends ShapedRecipe {
    private String group;
    private int width;
    private int height;
    private NonNullList<Ingredient> ingredients;
    private ItemStack result;
    private boolean mirror;
    private boolean shrink;
    private List<IngredientAction> ingredientActions;

    public ShapedKubeJSRecipe(ResourceLocation _id) {
        super(_id, "", 0, 0, NonNullList.func_191197_a((int)0, (Object)Ingredient.field_193370_a), ItemStack.field_190927_a);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return KubeJSRecipeEventHandler.SHAPED.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_194133_a(int w, int h) {
        return w >= this.width && h >= this.height;
    }

    public boolean func_77569_a(CraftingInventory craftingContainer, World level) {
        for (int x = 0; x <= craftingContainer.func_174922_i() - this.width; ++x) {
            for (int y = 0; y <= craftingContainer.func_174923_h() - this.height; ++y) {
                if (this.mirror && this.matches(craftingContainer, x, y, true)) {
                    return true;
                }
                if (!this.matches(craftingContainer, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingInventory craftingContainer, int x0, int y0, boolean mirrorPattern) {
        for (int x = 0; x < craftingContainer.func_174922_i(); ++x) {
            for (int y = 0; y < craftingContainer.func_174923_h(); ++y) {
                int m = x - x0;
                int n = y - y0;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (m >= 0 && n >= 0 && m < this.width && n < this.height) {
                    ingredient = mirrorPattern ? (Ingredient)this.ingredients.get(this.width - m - 1 + n * this.width) : (Ingredient)this.ingredients.get(m + n * this.width);
                }
                if (ingredient.test(craftingContainer.func_70301_a(x + y * craftingContainer.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(CraftingInventory craftingContainer) {
        return this.func_77571_b().func_77946_l();
    }

    public int func_192403_f() {
        return this.width;
    }

    public int func_192404_g() {
        return this.height;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory container) {
        NonNullList list = NonNullList.func_191197_a((int)container.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)IngredientAction.getRemaining(container, i, this.ingredientActions));
        }
        return list;
    }

    private static NonNullList<Ingredient> dissolvePattern(String[] pattern, Map<String, Ingredient> key, int w, int h) {
        NonNullList nonNullList = NonNullList.func_191197_a((int)(w * h), (Object)Ingredient.field_193370_a);
        HashSet set = Sets.newHashSet(key.keySet());
        set.remove(" ");
        for (int k = 0; k < pattern.length; ++k) {
            for (int l = 0; l < pattern[k].length(); ++l) {
                String string = pattern[k].substring(l, l + 1);
                Ingredient ingredient = key.get(string);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                set.remove(string);
                nonNullList.set(l + w * k, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonNullList;
    }

    private static String[] shrink(String[] strings) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int m = 0; m < strings.length; ++m) {
            String string = strings[m];
            i = Math.min(i, ShapedKubeJSRecipe.firstNonSpace(string));
            int n = ShapedKubeJSRecipe.lastNonSpace(string);
            j = Math.max(j, n);
            if (n < 0) {
                if (k == m) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (strings.length == l) {
            return new String[0];
        }
        String[] strings2 = new String[strings.length - l - k];
        for (int o = 0; o < strings2.length; ++o) {
            strings2[o] = strings[o + k].substring(i, j + 1);
        }
        return strings2;
    }

    private static int firstNonSpace(String string) {
        int i;
        for (i = 0; i < string.length() && string.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int lastNonSpace(String string) {
        int i;
        for (i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
        }
        return i;
    }

    private static String[] patternFromJson(JsonArray jsonArray) {
        String[] strings = new String[jsonArray.size()];
        if (strings.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (strings.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < strings.length; ++i) {
            String string = JSONUtils.func_151206_a((JsonElement)jsonArray.get(i), (String)("pattern[" + i + "]"));
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && strings[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            strings[i] = string;
        }
        return strings;
    }

    private static Map<String, Ingredient> keyFromJson(JsonObject jsonObject) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    public static class SerializerKJS
    extends AbstractRecipeSerializer<ShapedKubeJSRecipe> {
        public ShapedKubeJSRecipe fromJson(ResourceLocation id, JsonObject json) {
            ShapedKubeJSRecipe r = new ShapedKubeJSRecipe(id);
            r.mirror = !json.has("mirror") || json.get("mirror").getAsBoolean();
            r.shrink = !json.has("shrink") || json.get("shrink").getAsBoolean();
            r.group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map key = ShapedKubeJSRecipe.keyFromJson(JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] pattern = ShapedKubeJSRecipe.patternFromJson(JSONUtils.func_151214_t((JsonObject)json, (String)"pattern"));
            if (r.shrink) {
                pattern = ShapedKubeJSRecipe.shrink(pattern);
            }
            r.width = pattern[0].length();
            r.height = pattern.length;
            r.ingredients = ShapedKubeJSRecipe.dissolvePattern(pattern, key, r.width, r.height);
            r.result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            r.ingredientActions = IngredientAction.parseList(json.get("kubejs_actions"));
            return r;
        }

        public ShapedKubeJSRecipe fromNetwork(ResourceLocation id, PacketBuffer buf) {
            ShapedKubeJSRecipe r = new ShapedKubeJSRecipe(id);
            r.group = buf.func_150789_c(Short.MAX_VALUE);
            r.width = buf.func_150792_a();
            r.height = buf.func_150792_a();
            r.ingredients = NonNullList.func_191197_a((int)(r.width * r.height), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < r.width * r.height; ++i) {
                r.ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buf));
            }
            r.result = buf.func_150791_c();
            r.mirror = buf.readBoolean();
            r.shrink = buf.readBoolean();
            r.ingredientActions = IngredientAction.readList(buf);
            return r;
        }

        public void toNetwork(PacketBuffer buf, ShapedKubeJSRecipe r) {
            buf.func_180714_a(r.group);
            buf.func_150787_b(r.width);
            buf.func_150787_b(r.height);
            for (Ingredient ingredient : r.ingredients) {
                ingredient.func_199564_a(buf);
            }
            buf.func_150788_a(r.result);
            buf.writeBoolean(r.mirror);
            buf.writeBoolean(r.shrink);
            IngredientAction.writeList(buf, r.ingredientActions);
        }
    }
}

