/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.mod;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import org.jetbrains.annotations.Nullable;

public class IDSqueezerRecipeJS
extends RecipeJS {
    @Override
    public void create(ListJS args) {
        this.outputItems.addAll(this.parseResultItemList(args.get(0)));
        this.inputItems.add(this.parseIngredientItem(args.get(1)));
        this.json.addProperty("duration", (Number)40);
    }

    @Override
    public void deserialize() {
        JsonObject r = this.json.get("result").getAsJsonObject();
        if (r.has("fluid")) {
            this.outputItems.add(ItemStackJS.of(r.get("fluid")));
        }
        if (r.has("items")) {
            this.outputItems.addAll(this.parseResultItemList(r.get("items")));
        }
        this.inputItems.add(this.parseIngredientItem(this.json.get("item")));
    }

    @Override
    public void serialize() {
        if (this.serializeOutputs) {
            JsonObject o = new JsonObject();
            JsonArray a = new JsonArray();
            for (ItemStackJS stack : this.outputItems) {
                if (stack.getFluidStack() != null) {
                    o.add("fluid", stack.toResultJson());
                    continue;
                }
                a.add(stack.toResultJson());
            }
            if (a.size() > 0) {
                o.add("items", (JsonElement)a);
            }
            this.json.add("result", (JsonElement)o);
        }
        if (this.serializeInputs) {
            this.json.add("item", ((IngredientJS)this.inputItems.get(0)).toJson());
        }
    }

    public IDSqueezerRecipeJS duration(int i) {
        this.json.addProperty("duration", (Number)i);
        this.save();
        return this;
    }

    @Override
    public ItemStackJS parseResultItem(@Nullable Object o) {
        JsonElement e;
        if (o instanceof JsonObject && (e = ((JsonObject)o).get("item")) instanceof JsonObject) {
            ItemStackJS i = super.parseResultItem(e);
            if (((JsonObject)o).has("chance")) {
                i.setChance(((JsonObject)o).get("chance").getAsDouble());
            }
            return i;
        }
        return super.parseResultItem(o);
    }

    @Override
    public JsonElement serializeItemStack(ItemStackJS stack) {
        JsonObject o = new JsonObject();
        o.add("item", stack.toRawResultJson());
        if (stack.hasChance()) {
            o.addProperty("chance", (Number)stack.getChance());
        }
        return o;
    }
}

