/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.minecraft;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ShapedRecipeJS
extends RecipeJS {
    private final List<String> pattern = new ArrayList<String>();
    private final List<String> key = new ArrayList<String>();

    @Override
    public void create(ListJS args) {
        if (args.size() < 3) {
            if (args.size() < 2) {
                throw new RecipeExceptionJS("Requires 3 arguments - result, pattern and keys!");
            }
            this.outputItems.add(this.parseResultItem(args.get(0)));
            ListJS vertical = ListJS.orSelf(args.get(1));
            if (vertical.isEmpty()) {
                throw new RecipeExceptionJS("Pattern is empty!");
            }
            int id = 0;
            for (Object o : vertical) {
                StringBuilder horizontalPattern = new StringBuilder();
                ListJS horizontal = ListJS.orSelf(o);
                for (Object item : horizontal) {
                    IngredientJS ingredient = IngredientJS.of(item);
                    if (!ingredient.isEmpty()) {
                        String currentId = String.valueOf((char)(65 + id++));
                        horizontalPattern.append(currentId);
                        this.inputItems.add(ingredient);
                        this.key.add(currentId);
                        continue;
                    }
                    horizontalPattern.append(" ");
                }
                this.pattern.add(horizontalPattern.toString());
            }
            int maxLength = this.pattern.stream().mapToInt(String::length).max().getAsInt();
            ListIterator<String> iterator = this.pattern.listIterator();
            while (iterator.hasNext()) {
                iterator.set(StringUtils.rightPad((String)iterator.next(), (int)maxLength));
            }
            return;
        }
        this.outputItems.add(this.parseResultItem(args.get(0)));
        ListJS pattern1 = ListJS.orSelf(args.get(1));
        if (pattern1.isEmpty()) {
            throw new RecipeExceptionJS("Pattern is empty!");
        }
        ArrayList<String> airs = new ArrayList<String>(1);
        MapJS key1 = MapJS.of(args.get(2));
        if (key1 == null || key1.isEmpty()) {
            throw new RecipeExceptionJS("Key map is empty!");
        }
        for (String k : key1.keySet()) {
            Object o = key1.get(k);
            if (o == ItemStackJS.EMPTY || o.equals("minecraft:air")) {
                airs.add(k);
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(o, k));
            this.key.add(k);
        }
        for (Object p : pattern1) {
            String s = String.valueOf(p);
            for (String s1 : airs) {
                s = s.replace(s1, " ");
            }
            this.pattern.add(s);
        }
    }

    @Override
    public void deserialize() {
        this.outputItems.add(this.parseResultItem(this.json.get("result")));
        for (JsonElement e : this.json.get("pattern").getAsJsonArray()) {
            this.pattern.add(e.getAsString());
        }
        for (Map.Entry entry : this.json.get("key").getAsJsonObject().entrySet()) {
            this.inputItems.add(this.parseIngredientItem(entry.getValue(), (String)entry.getKey()));
            this.key.add((String)entry.getKey());
        }
    }

    @Override
    public void serialize() {
        if (this.serializeOutputs) {
            this.json.add("result", ((ItemStackJS)this.outputItems.get(0)).toResultJson());
        }
        if (this.serializeInputs) {
            JsonArray patternJson = new JsonArray();
            for (String s : this.pattern) {
                patternJson.add(s);
            }
            this.json.add("pattern", (JsonElement)patternJson);
            JsonObject keyJson = new JsonObject();
            for (int i = 0; i < this.key.size(); ++i) {
                keyJson.add(this.key.get(i), ((IngredientJS)this.inputItems.get(i)).toJson());
            }
            this.json.add("key", (JsonElement)keyJson);
        }
    }

    public ShapedRecipeJS noMirror() {
        this.json.addProperty("mirror", Boolean.valueOf(false));
        this.save();
        return this;
    }

    public ShapedRecipeJS noShrink() {
        this.json.addProperty("shrink", Boolean.valueOf(false));
        this.save();
        return this;
    }
}

