/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.recipe.IgnoredRecipeTypeJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.recipe.RecipeTypeJS;
import dev.latvian.kubejs.recipe.minecraft.ShapedRecipeJS;
import dev.latvian.kubejs.recipe.minecraft.ShapelessRecipeJS;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.util.ConsoleJS;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.architectury.ForgeEvent;
import me.shedaniel.architectury.event.Event;
import me.shedaniel.architectury.event.EventFactory;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

@ForgeEvent
public class RegisterRecipeHandlersEvent
extends net.minecraftforge.eventbus.api.Event {
    @Deprecated
    public static final Event<Consumer<RegisterRecipeHandlersEvent>> EVENT = EventFactory.createConsumerLoop(RegisterRecipeHandlersEvent.class);
    private final Map<ResourceLocation, RecipeTypeJS> map;

    public RegisterRecipeHandlersEvent(Map<ResourceLocation, RecipeTypeJS> m) {
        this.map = m;
    }

    public void register(RecipeTypeJS type) {
        this.map.put(Registries.getId(type.serializer, (RegistryKey)Registry.field_239679_Q_), type);
        KubeJS.LOGGER.info("Registered custom recipe handler for type " + type);
    }

    public void register(ResourceLocation id, Supplier<RecipeJS> f) {
        block2: {
            try {
                this.register(new RecipeTypeJS(Objects.requireNonNull((IRecipeSerializer)KubeJSRegistries.recipeSerializers().get(id)), f));
            }
            catch (NullPointerException e) {
                if (!ServerSettings.instance.logErroringRecipes) break block2;
                ConsoleJS.SERVER.warn("Failed to register handler for recipe type " + id + " as it doesn't exist!");
            }
        }
    }

    public void register(String id, Supplier<RecipeJS> f) {
        this.register(new ResourceLocation(id), f);
    }

    public void ignore(ResourceLocation id) {
        block2: {
            try {
                this.register(new IgnoredRecipeTypeJS(Objects.requireNonNull((IRecipeSerializer)KubeJSRegistries.recipeSerializers().get(id))));
            }
            catch (NullPointerException e) {
                if (!ServerSettings.instance.logErroringRecipes) break block2;
                ConsoleJS.SERVER.warn("Failed to ignore recipe type " + id + " as it doesn't exist!");
            }
        }
    }

    public void ignore(String id) {
        this.ignore(new ResourceLocation(id));
    }

    public void registerShaped(ResourceLocation id) {
        this.register(id, ShapedRecipeJS::new);
    }

    public void registerShapeless(ResourceLocation id) {
        this.register(id, ShapelessRecipeJS::new);
    }

    private void handleMissingSerializer(ResourceLocation id) {
        if (ServerSettings.instance.logInvalidRecipeHandlers) {
            throw new NullPointerException("Cannot find recipe serializer: " + id);
        }
        if (ServerSettings.instance.logErroringRecipes) {
            KubeJS.LOGGER.warn("Skipping recipe handler for serializer " + id + " as it does not exist!");
        }
    }
}

