/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import dev.latvian.kubejs.core.PlayerInteractionManagerKJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.net.PaintMessage;
import dev.latvian.kubejs.net.SendDataFromServerMessage;
import dev.latvian.kubejs.player.AdvancementJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.player.PlayerStatsJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.ServerWorldJS;
import java.util.Date;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.server.management.ProfileBanEntry;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import org.jetbrains.annotations.Nullable;

public class ServerPlayerJS
extends PlayerJS<ServerPlayerEntity> {
    public final ServerJS server;
    private final boolean hasClientMod;

    public ServerPlayerJS(ServerPlayerDataJS d, ServerWorldJS w, ServerPlayerEntity p) {
        super(d, w, p);
        this.server = w.getServer();
        this.hasClientMod = d.hasClientMod();
    }

    @Override
    public PlayerStatsJS getStats() {
        return new PlayerStatsJS(this, (StatisticsManager)((ServerPlayerEntity)this.minecraftPlayer).func_147099_x());
    }

    @Override
    public void paint(CompoundNBT renderer) {
        new PaintMessage(renderer).sendTo((ServerPlayerEntity)this.minecraftPlayer);
    }

    @Override
    public boolean isMiningBlock() {
        return ((PlayerInteractionManagerKJS)((ServerPlayerEntity)this.minecraftPlayer).field_71134_c).isDestroyingBlockKJS();
    }

    public void setCreativeMode(boolean mode) {
        ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(mode ? GameType.CREATIVE : GameType.SURVIVAL);
    }

    public void setGameMode(String mode) {
        switch (mode) {
            case "survival": {
                ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(GameType.SURVIVAL);
                break;
            }
            case "creative": {
                ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(GameType.CREATIVE);
                break;
            }
            case "adventure": {
                ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(GameType.ADVENTURE);
                break;
            }
            case "spectator": {
                ((ServerPlayerEntity)this.minecraftPlayer).field_71134_c.func_73076_a(GameType.SPECTATOR);
            }
        }
    }

    @Deprecated
    public boolean isOP() {
        return this.isOp();
    }

    public boolean isOp() {
        return this.server.getMinecraftServer().func_184103_al().func_152596_g(((ServerPlayerEntity)this.minecraftPlayer).func_146103_bH());
    }

    public void kick(ITextComponent reason) {
        ((ServerPlayerEntity)this.minecraftPlayer).field_71135_a.func_194028_b(reason);
    }

    public void kick() {
        this.kick((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.kicked"));
    }

    public void ban(String banner, String reason, long expiresInMillis) {
        Date date = new Date();
        ProfileBanEntry userlistbansentry = new ProfileBanEntry(((ServerPlayerEntity)this.minecraftPlayer).func_146103_bH(), date, banner, new Date(date.getTime() + (expiresInMillis <= 0L ? 315569260000L : expiresInMillis)), reason);
        this.server.getMinecraftServer().func_184103_al().func_152608_h().func_152687_a((UserListEntry)userlistbansentry);
        this.kick((ITextComponent)new TranslationTextComponent("multiplayer.disconnect.banned"));
    }

    public boolean getHasClientMod() {
        return this.hasClientMod;
    }

    public boolean isAdvancementDone(ResourceLocation id) {
        AdvancementJS a = ServerJS.instance.getAdvancement(id);
        return a != null && ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192747_a(a.advancement).func_192105_a();
    }

    public void unlockAdvancement(ResourceLocation id) {
        AdvancementJS a = ServerJS.instance.getAdvancement(id);
        if (a != null) {
            AdvancementProgress advancementprogress = ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192747_a(a.advancement);
            for (String s : advancementprogress.func_192107_d()) {
                ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192750_a(a.advancement, s);
            }
        }
    }

    public void revokeAdvancement(ResourceLocation id) {
        AdvancementProgress advancementprogress;
        AdvancementJS a = ServerJS.instance.getAdvancement(id);
        if (a != null && (advancementprogress = ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192747_a(a.advancement)).func_192108_b()) {
            for (String s : advancementprogress.func_192102_e()) {
                ((ServerPlayerEntity)this.minecraftPlayer).func_192039_O().func_192744_b(a.advancement, s);
            }
        }
    }

    @Override
    public void setSelectedSlot(int index) {
        int p = this.getSelectedSlot();
        super.setSelectedSlot(index);
        int n = this.getSelectedSlot();
        if (p != n && ((ServerPlayerEntity)this.minecraftPlayer).field_71135_a != null) {
            ((ServerPlayerEntity)this.minecraftPlayer).field_71135_a.func_147359_a((IPacket)new SHeldItemChangePacket(n));
        }
    }

    @Override
    public void setMouseItem(ItemStackJS item) {
        super.setMouseItem(item);
        if (((ServerPlayerEntity)this.minecraftPlayer).field_71135_a != null) {
            ((ServerPlayerEntity)this.minecraftPlayer).func_71113_k();
        }
    }

    @Override
    public void sendData(String channel, @Nullable CompoundNBT data) {
        if (!channel.isEmpty()) {
            new SendDataFromServerMessage(channel, data).sendTo((ServerPlayerEntity)this.minecraftPlayer);
        }
    }

    @Nullable
    public BlockContainerJS getSpawnLocation() {
        BlockPos pos = ((ServerPlayerEntity)this.minecraftPlayer).func_241140_K_();
        return pos == null ? null : new BlockContainerJS(((ServerPlayerEntity)this.minecraftPlayer).field_70170_p, pos);
    }

    public void setSpawnLocation(BlockContainerJS c) {
        ((ServerPlayerEntity)this.minecraftPlayer).func_242111_a(c.minecraftLevel.func_234923_W_(), c.getPos(), 0.0f, true, false);
    }
}

