/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import dev.latvian.kubejs.CommonProperties;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.core.EntityKJS;
import dev.latvian.kubejs.player.AttachPlayerDataEvent;
import dev.latvian.kubejs.player.ChestEventJS;
import dev.latvian.kubejs.player.InventoryEventJS;
import dev.latvian.kubejs.player.InventoryListener;
import dev.latvian.kubejs.player.PlayerAdvancementEventJS;
import dev.latvian.kubejs.player.PlayerChatEventJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.player.SimplePlayerEventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.stages.Stages;
import me.shedaniel.architectury.event.events.ChatEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.event.events.TickEvent;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;

public class KubeJSPlayerEventHandler {
    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(KubeJSPlayerEventHandler::loggedIn);
        PlayerEvent.PLAYER_QUIT.register(KubeJSPlayerEventHandler::loggedOut);
        PlayerEvent.PLAYER_RESPAWN.register(KubeJSPlayerEventHandler::respawn);
        PlayerEvent.PLAYER_CLONE.register(KubeJSPlayerEventHandler::cloned);
        TickEvent.PLAYER_POST.register(KubeJSPlayerEventHandler::tick);
        ChatEvent.SERVER.register(KubeJSPlayerEventHandler::chat);
        PlayerEvent.PLAYER_ADVANCEMENT.register(KubeJSPlayerEventHandler::advancement);
        PlayerEvent.OPEN_MENU.register(KubeJSPlayerEventHandler::inventoryOpened);
        PlayerEvent.CLOSE_MENU.register(KubeJSPlayerEventHandler::inventoryClosed);
    }

    public static void loggedIn(ServerPlayerEntity player) {
        if (ServerJS.instance != null) {
            ServerPlayerDataJS p = new ServerPlayerDataJS(ServerJS.instance, player.func_110124_au(), player.func_146103_bH().getName(), KubeJS.nextClientHasClientMod);
            KubeJS.nextClientHasClientMod = false;
            p.getServer().playerMap.put(p.getId(), p);
            new AttachPlayerDataEvent(p).invoke();
            new SimplePlayerEventJS((PlayerEntity)player).post("player.logged_in");
            player.field_71069_bz.func_75132_a((IContainerListener)new InventoryListener(player));
        }
        if (!ScriptType.SERVER.errors.isEmpty() && !CommonProperties.get().hideServerScriptErrors) {
            player.func_146105_b((ITextComponent)new StringTextComponent("KubeJS errors found [" + ScriptType.SERVER.errors.size() + "]! Run '/kubejs errors' for more info").func_240699_a_(TextFormatting.DARK_RED), false);
        }
        Stages.get((PlayerEntity)player).sync();
    }

    private static void respawn(ServerPlayerEntity player, boolean b) {
        Stages.get((PlayerEntity)player).sync();
    }

    public static void loggedOut(ServerPlayerEntity player) {
        if (ServerJS.instance == null || !ServerJS.instance.playerMap.containsKey(player.func_110124_au())) {
            return;
        }
        new SimplePlayerEventJS((PlayerEntity)player).post("player.logged_out");
        ServerJS.instance.playerMap.remove(player.func_110124_au());
    }

    public static void cloned(ServerPlayerEntity oldPlayer, ServerPlayerEntity newPlayer, boolean wonGame) {
        ((EntityKJS)newPlayer).getPersistentDataKJS().func_197643_a(((EntityKJS)oldPlayer).getPersistentDataKJS());
        newPlayer.field_71069_bz.func_75132_a((IContainerListener)new InventoryListener(newPlayer));
    }

    public static void tick(PlayerEntity player) {
        if (ServerJS.instance != null && player instanceof ServerPlayerEntity) {
            new SimplePlayerEventJS(player).post("player.tick");
        }
    }

    @NotNull
    public static ActionResult<ITextComponent> chat(ServerPlayerEntity player, String message, ITextComponent component) {
        PlayerChatEventJS event = new PlayerChatEventJS(player, message, component);
        if (event.post("player.chat")) {
            return ActionResult.func_226251_d_((Object)event.component);
        }
        return ActionResult.func_226250_c_((Object)event.component);
    }

    public static void advancement(ServerPlayerEntity player, Advancement advancement) {
        new PlayerAdvancementEventJS(player, advancement).post("player.advancement");
    }

    public static void inventoryOpened(PlayerEntity player, Container menu) {
        if (player instanceof ServerPlayerEntity && !(menu instanceof PlayerContainer)) {
            menu.func_75132_a((IContainerListener)new InventoryListener((ServerPlayerEntity)player));
        }
        new InventoryEventJS(player, menu).post("player.inventory.opened");
        if (menu instanceof ChestContainer) {
            new ChestEventJS(player, menu).post("player.chest.opened");
        }
    }

    public static void inventoryClosed(PlayerEntity player, Container menu) {
        new InventoryEventJS(player, menu).post("player.inventory.closed");
        if (menu instanceof ChestContainer) {
            new ChestEventJS(player, menu).post("player.chest.closed");
        }
    }
}

