/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.integration.jei;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.event.EventJS;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class RemoveJEIRecipesEvent
extends EventJS {
    private final IJeiRuntime runtime;
    private final HashMap<ResourceLocation, Collection<ResourceLocation>> recipesRemoved;
    private final Collection<IRecipeCategory<?>> allCategories;

    public RemoveJEIRecipesEvent(IJeiRuntime r) {
        this.runtime = r;
        this.recipesRemoved = new HashMap();
        this.allCategories = this.runtime.getRecipeManager().getRecipeCategories();
    }

    public Collection<IRecipeCategory<?>> getCategories() {
        return this.allCategories;
    }

    public Collection<ResourceLocation> getCategoryIds() {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        for (IRecipeCategory<?> allCategory : this.allCategories) {
            set.add(allCategory.getUid());
        }
        return set;
    }

    public void remove(ResourceLocation category, ResourceLocation[] recipesToRemove) {
        for (ResourceLocation toRemove : recipesToRemove) {
            this.recipesRemoved.computeIfAbsent(category, _0 -> new HashSet()).add(toRemove);
        }
    }

    public void yeet(ResourceLocation category, ResourceLocation[] recipesToYeet) {
        this.remove(category, recipesToYeet);
    }

    @Override
    protected void afterPosted(boolean result) {
        IRecipeManager rm = this.runtime.getRecipeManager();
        for (ResourceLocation cat : this.recipesRemoved.keySet()) {
            try {
                IRecipeCategory category = rm.getRecipeCategory(cat);
                if (IRecipe.class.isAssignableFrom(category.getRecipeClass())) {
                    for (ResourceLocation id : this.recipesRemoved.get(cat)) {
                        try {
                            boolean found = false;
                            for (Object o : rm.getRecipes(category)) {
                                IRecipe recipe = (IRecipe)o;
                                if (!id.equals((Object)recipe.func_199560_c())) continue;
                                rm.hideRecipe((Object)recipe, cat);
                                found = true;
                                break;
                            }
                            if (found) continue;
                            KubeJS.LOGGER.warn("Failed to remove recipe {} for category {}: Recipe doesn't exist!", (Object)id, (Object)cat);
                        }
                        catch (Exception e) {
                            KubeJS.LOGGER.warn("Failed to remove recipe {} for category {}: An unexpected error was thrown!", (Object)id, (Object)cat);
                        }
                    }
                    continue;
                }
                KubeJS.LOGGER.warn("Failed to remove recipes for category {}: Recipe type is unsupported!", (Object)cat);
            }
            catch (IllegalStateException | NullPointerException e) {
                KubeJS.LOGGER.warn("Failed to remove recipes for category {}: Category doesn't exist!", (Object)cat);
                KubeJS.LOGGER.info("Available categories: " + this.getCategoryIds());
            }
        }
    }
}

