/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.bindings.RarityWrapper;
import dev.latvian.kubejs.util.BuilderBase;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.item.BucketItem;
import net.minecraft.util.ResourceLocation;

public class FluidBuilder
extends BuilderBase {
    public String stillTexture;
    public String flowingTexture;
    public int color = -1;
    public int bucketColor = -1;
    public int luminosity = 0;
    public int density = 1000;
    public int temperature = 300;
    public int viscosity = 1000;
    public boolean isGaseous;
    public RarityWrapper rarity = RarityWrapper.COMMON;
    public Object extraPlatformInfo;
    public FlowingFluid stillFluid;
    public FlowingFluid flowingFluid;
    public BucketItem bucketItem;
    public FlowingFluidBlock block;
    private JsonObject blockstateJson;
    private JsonObject blockModelJson;

    public FluidBuilder(String i) {
        super(i);
        this.textureStill(KubeJS.id("fluid/fluid_thin"));
        this.textureFlowing(KubeJS.id("fluid/fluid_thin_flow"));
    }

    @Override
    public String getBuilderType() {
        return "fluid";
    }

    public FluidBuilder color(int c) {
        this.color = c;
        if ((this.color & 0xFFFFFF) == this.color) {
            this.color |= 0xFF000000;
        }
        return this.bucketColor(this.color);
    }

    public FluidBuilder bucketColor(int c) {
        this.bucketColor = c;
        if ((this.bucketColor & 0xFFFFFF) == this.bucketColor) {
            this.bucketColor |= 0xFF000000;
        }
        return this;
    }

    public FluidBuilder textureStill(ResourceLocation id) {
        this.stillTexture = id.toString();
        return this;
    }

    public FluidBuilder textureFlowing(ResourceLocation id) {
        this.flowingTexture = id.toString();
        return this;
    }

    public FluidBuilder textureThick(int color) {
        return this.textureStill(KubeJS.id("fluid/fluid_thick")).textureFlowing(KubeJS.id("fluid/fluid_thick_flow")).color(color);
    }

    public FluidBuilder textureThin(int color) {
        return this.textureStill(KubeJS.id("fluid/fluid_thin")).textureFlowing(KubeJS.id("fluid/fluid_thin_flow")).color(color);
    }

    public FluidBuilder luminosity(int luminosity) {
        this.luminosity = luminosity;
        return this;
    }

    public FluidBuilder density(int density) {
        this.density = density;
        return this;
    }

    public FluidBuilder temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    public FluidBuilder viscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    public FluidBuilder gaseous() {
        this.isGaseous = true;
        return this;
    }

    public FluidBuilder rarity(RarityWrapper rarity) {
        this.rarity = rarity;
        return this;
    }

    public void setBlockstateJson(JsonObject o) {
        this.blockstateJson = o;
    }

    public JsonObject getBlockstateJson() {
        if (this.blockstateJson == null) {
            this.blockstateJson = new JsonObject();
            JsonObject variants = new JsonObject();
            JsonObject modelo = new JsonObject();
            modelo.addProperty("model", this.newID("block/", "").toString());
            variants.add("", (JsonElement)modelo);
            this.blockstateJson.add("variants", (JsonElement)variants);
        }
        return this.blockstateJson;
    }

    public void setBlockModelJson(JsonObject o) {
        this.blockModelJson = o;
    }

    public JsonObject getBlockModelJson() {
        if (this.blockModelJson == null) {
            this.blockModelJson = new JsonObject();
            JsonObject textures = new JsonObject();
            textures.addProperty("particle", this.stillTexture);
            this.blockModelJson.add("textures", (JsonElement)textures);
            return this.blockModelJson;
        }
        return this.blockModelJson;
    }
}

