/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.command;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.core.MinecraftServerKJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.kubejs.net.PaintMessage;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.CustomCommandEventJS;
import dev.latvian.kubejs.server.ServerScriptManager;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.stages.Stages;
import dev.latvian.kubejs.util.Tags;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.impl.ReloadCommand;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.storage.IServerConfiguration;

public class KubeJSCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"kubejs").then(Commands.func_197057_a((String)"custom_command").then(Commands.func_197056_a((String)"id", (ArgumentType)StringArgumentType.word()).executes(context -> KubeJSCommands.customCommand((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"id")))))).then(Commands.func_197057_a((String)"hand").executes(context -> KubeJSCommands.hand(((CommandSource)context.getSource()).func_197035_h(), Hand.MAIN_HAND)))).then(Commands.func_197057_a((String)"offhand").executes(context -> KubeJSCommands.hand(((CommandSource)context.getSource()).func_197035_h(), Hand.OFF_HAND)))).then(Commands.func_197057_a((String)"inventory").executes(context -> KubeJSCommands.inventory(((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"hotbar").executes(context -> KubeJSCommands.hotbar(((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"errors").executes(context -> KubeJSCommands.errors((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"warnings").executes(context -> KubeJSCommands.warnings((CommandSource)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"reload").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"startup_scripts").requires(source -> source.func_197028_i().func_71264_H() || source.func_197034_c(2))).executes(context -> KubeJSCommands.reloadStartup((CommandSource)context.getSource())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"server_scripts").requires(source -> source.func_197028_i().func_71264_H() || source.func_197034_c(2))).executes(context -> KubeJSCommands.reloadServer((CommandSource)context.getSource())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"client_scripts").requires(source -> true)).executes(context -> KubeJSCommands.reloadClient((CommandSource)context.getSource())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"textures").requires(source -> true)).executes(context -> KubeJSCommands.reloadTextures((CommandSource)context.getSource())))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"lang").requires(source -> true)).executes(context -> KubeJSCommands.reloadLang((CommandSource)context.getSource()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"export").requires(source -> source.func_197028_i().func_71264_H() || source.func_197034_c(2))).executes(context -> KubeJSCommands.export((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"list_tag").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"tag", (ArgumentType)ResourceLocationArgument.func_197197_a()).executes(context -> KubeJSCommands.tagObjects(((CommandSource)context.getSource()).func_197035_h(), Tags.items(), Registry.field_239714_o_, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"tag")))).then(Commands.func_197057_a((String)"item").executes(context -> KubeJSCommands.tagObjects(((CommandSource)context.getSource()).func_197035_h(), Tags.items(), Registry.field_239714_o_, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"tag"))))).then(Commands.func_197057_a((String)"block").executes(context -> KubeJSCommands.tagObjects(((CommandSource)context.getSource()).func_197035_h(), Tags.blocks(), Registry.field_239711_l_, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"tag"))))).then(Commands.func_197057_a((String)"fluid").executes(context -> KubeJSCommands.tagObjects(((CommandSource)context.getSource()).func_197035_h(), Tags.fluids(), Registry.field_239709_j_, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"tag"))))).then(Commands.func_197057_a((String)"entity_type").executes(context -> KubeJSCommands.tagObjects(((CommandSource)context.getSource()).func_197035_h(), Tags.entityTypes(), Registry.field_239713_n_, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"tag"))))))).then(Commands.func_197057_a((String)"wiki").executes(context -> KubeJSCommands.wiki((CommandSource)context.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"stages").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.addStage((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"stage", (ArgumentType)StringArgumentType.string()).executes(context -> KubeJSCommands.removeStage((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"stage"))))))).then(Commands.func_197057_a((String)"clear").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> KubeJSCommands.clearStages((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player")))))).then(Commands.func_197057_a((String)"list").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> KubeJSCommands.listStages((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player"))))))).then(Commands.func_197057_a((String)"painter").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197094_d()).then(Commands.func_197056_a((String)"object", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(context -> KubeJSCommands.painter((CommandSource)context.getSource(), EntityArgument.func_197090_e((CommandContext)context, (String)"player"), NBTCompoundTagArgument.func_218042_a((CommandContext)context, (String)"object")))))));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"kjs_hand").executes(context -> KubeJSCommands.hand(((CommandSource)context.getSource()).func_197035_h(), Hand.MAIN_HAND)));
    }

    private static ITextComponent copy(String s, TextFormatting col, String info) {
        StringTextComponent component = new StringTextComponent("- ");
        component.func_230530_a_(component.func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GRAY)));
        component.func_230530_a_(component.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)));
        component.func_230530_a_(component.func_150256_b().func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(info + " (Click to copy)"))));
        component.func_230529_a_((ITextComponent)new StringTextComponent(s).func_240699_a_(col));
        return component;
    }

    private static int customCommand(CommandSource source, String id) {
        new CustomCommandEventJS((World)source.func_197023_e(), source.func_197022_f(), new BlockPos(source.func_197036_d()), id).post(ScriptType.SERVER, "server.custom_command", id);
        return 1;
    }

    private static int hand(ServerPlayerEntity player, Hand hand) {
        player.func_145747_a((ITextComponent)new StringTextComponent("Item in hand:"), Util.field_240973_b_);
        ItemStackJS stack = ItemStackJS.of(player.func_184586_b(hand));
        player.func_145747_a(KubeJSCommands.copy(stack.toString(), TextFormatting.GREEN, "Item ID"), Util.field_240973_b_);
        ArrayList<ResourceLocation> tags = new ArrayList<ResourceLocation>(Tags.byItem(stack.getItem()));
        tags.sort(null);
        for (ResourceLocation id : tags) {
            player.func_145747_a(KubeJSCommands.copy("'#" + id + "'", TextFormatting.YELLOW, "Item Tag [" + TagIngredientJS.createTag(id.toString()).getStacks().size() + " items]"), Util.field_240973_b_);
        }
        player.func_145747_a(KubeJSCommands.copy("'@" + stack.getMod() + "'", TextFormatting.AQUA, "Mod [" + new ModIngredientJS(stack.getMod()).getStacks().size() + " items]"), Util.field_240973_b_);
        if (stack.getItem().func_77640_w() != null) {
            player.func_145747_a(KubeJSCommands.copy("'%" + stack.getItemGroup() + "'", TextFormatting.LIGHT_PURPLE, "Item Group [" + new GroupIngredientJS(stack.getItem().func_77640_w()).getStacks().size() + " items]"), Util.field_240973_b_);
        }
        return 1;
    }

    private static int inventory(ServerPlayerEntity player) {
        return KubeJSCommands.dump((List<ItemStack>)player.field_71071_by.field_70462_a, player, "Inventory");
    }

    private static int hotbar(ServerPlayerEntity player) {
        return KubeJSCommands.dump(player.field_71071_by.field_70462_a.subList(0, 9), player, "Hotbar");
    }

    private static int dump(List<ItemStack> stacks, ServerPlayerEntity player, String name) {
        ArrayList<ItemStackJS> stackList = new ArrayList<ItemStackJS>(stacks.size());
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            stackList.add(ItemStackJS.of(stack));
        }
        String dump = ((Object)stackList).toString();
        player.func_145747_a(KubeJSCommands.copy(dump, TextFormatting.WHITE, name + " Item List"), Util.field_240973_b_);
        return 1;
    }

    private static int errors(CommandSource source) {
        if (ScriptType.SERVER.errors.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("No errors found!").func_240699_a_(TextFormatting.GREEN), false);
            if (!ScriptType.SERVER.warnings.isEmpty()) {
                source.func_197030_a((ITextComponent)new StringTextComponent(ScriptType.SERVER.warnings.size() + " warnings found. Run /kubejs warnings to see them").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)16753920))), false);
            }
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.errors.size(); ++i) {
            source.func_197030_a((ITextComponent)new StringTextComponent("[" + (i + 1) + "] " + ScriptType.SERVER.errors.get(i)).func_240699_a_(TextFormatting.RED), false);
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("More info in 'logs/kubejs/server.txt'").func_240699_a_(TextFormatting.DARK_RED), false);
        if (!ScriptType.SERVER.warnings.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent(ScriptType.SERVER.warnings.size() + " warnings found. Run '/kubejs warnings' to see them").func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)16753920))), false);
        }
        return 1;
    }

    private static int warnings(CommandSource source) {
        if (ScriptType.SERVER.warnings.isEmpty()) {
            source.func_197030_a((ITextComponent)new StringTextComponent("No warnings found!").func_240699_a_(TextFormatting.GREEN), false);
            return 1;
        }
        for (int i = 0; i < ScriptType.SERVER.warnings.size(); ++i) {
            source.func_197030_a((ITextComponent)new StringTextComponent("[" + (i + 1) + "] " + ScriptType.SERVER.warnings.get(i)).func_240703_c_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)16753920))), false);
        }
        return 1;
    }

    private static int reloadStartup(CommandSource source) {
        KubeJS.startupScriptManager.unload();
        KubeJS.startupScriptManager.loadFromDirectory();
        KubeJS.startupScriptManager.load();
        UtilsJS.postModificationEvents();
        source.func_197030_a((ITextComponent)new StringTextComponent("Done!"), false);
        return 1;
    }

    private static int reloadServer(CommandSource source) {
        ServerScriptManager.instance.reloadScriptManager(((MinecraftServerKJS)source.func_197028_i()).getServerResourcesKJS().func_240970_h_());
        UtilsJS.postModificationEvents();
        source.func_197030_a((ITextComponent)new StringTextComponent("Done! To reload recipes, tags, loot tables and other datapack things, run /reload"), false);
        return 1;
    }

    private static int reloadClient(CommandSource source) {
        KubeJS.PROXY.reloadClientInternal();
        source.func_197030_a((ITextComponent)new StringTextComponent("Done! To reload textures, models and other assets, press F3 + T"), false);
        return 1;
    }

    private static int reloadTextures(CommandSource source) {
        KubeJS.PROXY.reloadTextures();
        return 1;
    }

    private static int reloadLang(CommandSource source) {
        KubeJS.PROXY.reloadLang();
        return 1;
    }

    private static int export(CommandSource source) {
        if (ServerSettings.dataExport != null) {
            return 0;
        }
        ServerSettings.source = source;
        ServerSettings.dataExport = new JsonObject();
        source.func_197030_a((ITextComponent)new StringTextComponent("Reloading server and exporting data..."), false);
        MinecraftServer minecraftServer = source.func_197028_i();
        ResourcePackList packRepository = minecraftServer.func_195561_aH();
        IServerConfiguration worldData = minecraftServer.func_240793_aU_();
        Collection collection = packRepository.func_232621_d_();
        packRepository.func_198983_a();
        ArrayList collection2 = Lists.newArrayList((Iterable)collection);
        List collection3 = worldData.func_230403_C_().func_234887_b_();
        for (String string : packRepository.func_232616_b_()) {
            if (collection3.contains(string) || collection2.contains(string)) continue;
            collection2.add(string);
        }
        ReloadCommand.func_241062_a_((Collection)collection2, (CommandSource)source);
        return 1;
    }

    private static int outputRecipes(ServerPlayerEntity player) {
        player.func_145747_a((ITextComponent)new StringTextComponent("WIP!"), Util.field_240973_b_);
        return 1;
    }

    private static int inputRecipes(ServerPlayerEntity player) {
        player.func_145747_a((ITextComponent)new StringTextComponent("WIP!"), Util.field_240973_b_);
        return 1;
    }

    private static int checkRecipeConflicts(ServerPlayerEntity player) {
        player.func_145747_a((ITextComponent)new StringTextComponent("WIP!"), Util.field_240973_b_);
        return 1;
    }

    private static <T> int tagObjects(ServerPlayerEntity player, ITagCollection<T> collection, RegistryKey<Registry<T>> reg, ResourceLocation t) {
        ITag tag = collection.func_199910_a(t);
        if (tag == null || tag.func_230236_b_().isEmpty()) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Tag not found!"), Util.field_240973_b_);
            return 0;
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(t + ":"), Util.field_240973_b_);
        for (Object item : tag.func_230236_b_()) {
            ResourceLocation id = Registries.getId(item, reg);
            if (id == null) {
                player.func_145747_a((ITextComponent)new StringTextComponent("- " + item), Util.field_240973_b_);
                continue;
            }
            player.func_145747_a((ITextComponent)new StringTextComponent("- " + id), Util.field_240973_b_);
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(tag.func_230236_b_().size() + " elements"), Util.field_240973_b_);
        return 1;
    }

    private static int wiki(CommandSource source) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Click here to open the Wiki").func_240699_a_(TextFormatting.BLUE).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://kubejs.com/"))), false);
        return 1;
    }

    private static int addStage(CommandSource source, Collection<ServerPlayerEntity> players, String stage) {
        for (ServerPlayerEntity p : players) {
            if (!Stages.get((PlayerEntity)p).add(stage)) continue;
            source.func_197030_a((ITextComponent)new StringTextComponent("Added '" + stage + "' stage for " + p.func_195047_I_()), false);
        }
        return 1;
    }

    private static int removeStage(CommandSource source, Collection<ServerPlayerEntity> players, String stage) {
        for (ServerPlayerEntity p : players) {
            if (!Stages.get((PlayerEntity)p).remove(stage)) continue;
            source.func_197030_a((ITextComponent)new StringTextComponent("Removed '" + stage + "' stage for " + p.func_195047_I_()), false);
        }
        return 1;
    }

    private static int clearStages(CommandSource source, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity p : players) {
            if (!Stages.get((PlayerEntity)p).clear()) continue;
            source.func_197030_a((ITextComponent)new StringTextComponent("Cleared stages for " + p.func_195047_I_()), false);
        }
        return 1;
    }

    private static int listStages(CommandSource source, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity p : players) {
            source.func_197030_a((ITextComponent)new StringTextComponent(p.func_195047_I_() + " stages:"), false);
            Stages.get((PlayerEntity)p).getAll().stream().sorted().forEach(s -> source.func_197030_a((ITextComponent)new StringTextComponent("- " + s), false));
        }
        return 1;
    }

    private static int painter(CommandSource source, Collection<ServerPlayerEntity> players, CompoundNBT object) {
        new PaintMessage(object).sendTo(players);
        return 1;
    }
}

