/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.client.painter;

import dev.latvian.kubejs.client.painter.PainterObject;
import dev.latvian.kubejs.client.painter.PainterObjectStorage;
import dev.latvian.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.kubejs.client.painter.world.WorldPainterObject;
import dev.latvian.kubejs.net.PainterUpdatedEventJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.unit.FixedUnit;
import dev.latvian.mods.rhino.util.unit.MutableUnit;
import dev.latvian.mods.rhino.util.unit.Unit;
import dev.latvian.mods.rhino.util.unit.UnitStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.Nullable;

public class Painter {
    public static final transient Painter INSTANCE = new Painter();
    public static final Random RANDOM = new Random();
    public static final int DRAW_ALWAYS = 0;
    public static final int DRAW_INGAME = 1;
    public static final int DRAW_GUI = 2;
    public static final int CENTER = 0;
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int TOP = -1;
    public static final int BOTTOM = 1;
    private final Object lock = new Object();
    private final Map<String, Supplier<PainterObject>> objectRegistry = new HashMap<String, Supplier<PainterObject>>();
    private final PainterObjectStorage storage = new PainterObjectStorage();
    private ScreenPainterObject[] screenObjects = null;
    private WorldPainterObject[] worldObjects = null;
    public final UnitStorage unitStorage = new UnitStorage();
    public final MutableUnit deltaUnit = new MutableUnit(1.0f);
    public final MutableUnit screenWidthUnit;
    public final MutableUnit screenHeightUnit;
    public final MutableUnit mouseXUnit;
    public final MutableUnit mouseYUnit;

    private Painter() {
        this.unitStorage.setVariable("delta", (Unit)this.deltaUnit);
        this.screenWidthUnit = new MutableUnit(1.0f);
        this.unitStorage.setVariable("screenW", (Unit)this.screenWidthUnit);
        this.screenHeightUnit = new MutableUnit(1.0f);
        this.unitStorage.setVariable("screenH", (Unit)this.screenHeightUnit);
        this.mouseXUnit = new MutableUnit(0.0f);
        this.unitStorage.setVariable("mouseX", (Unit)this.mouseXUnit);
        this.mouseYUnit = new MutableUnit(0.0f);
        this.unitStorage.setVariable("mouseY", (Unit)this.mouseYUnit);
    }

    @HideFromJS
    public void registerObject(String name, Supplier<PainterObject> supplier) {
        this.objectRegistry.put(name, supplier);
    }

    @Nullable
    public PainterObject make(String type) {
        Supplier<PainterObject> supplier = this.objectRegistry.get(type);
        return supplier == null ? null : supplier.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PainterObject getObject(String key) {
        Object object = this.lock;
        synchronized (object) {
            return this.storage.getObject(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(CompoundNBT root) {
        Object object = this.lock;
        synchronized (object) {
            this.storage.handle(root);
            this.screenObjects = null;
            this.worldObjects = null;
            new PainterUpdatedEventJS().post("client.painter_updated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.storage.clear();
            this.screenObjects = null;
            this.worldObjects = null;
            new PainterUpdatedEventJS().post("client.painter_updated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HideFromJS
    public ScreenPainterObject[] getScreenObjects() {
        if (this.screenObjects == null) {
            Object object = this.lock;
            synchronized (object) {
                this.screenObjects = this.storage.createScreenObjects();
            }
        }
        return this.screenObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HideFromJS
    public WorldPainterObject[] getWorldObjects() {
        if (this.worldObjects == null) {
            Object object = this.lock;
            synchronized (object) {
                this.worldObjects = this.storage.createWorldObjects();
            }
        }
        return this.worldObjects;
    }

    public void setVariable(String key, Unit variable) {
        Unit original = this.unitStorage.getVariable(key);
        if (original instanceof MutableUnit) {
            ((MutableUnit)original).set(variable.get());
        } else if (variable instanceof FixedUnit) {
            this.unitStorage.setVariable(key, (Unit)new MutableUnit(variable.get()));
        } else {
            this.unitStorage.setVariable(key, variable);
        }
    }
}

