/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.KubeJSPaths;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.client.ClientLoggedInEventJS;
import dev.latvian.kubejs.client.ClientProperties;
import dev.latvian.kubejs.client.ClientTickEventJS;
import dev.latvian.kubejs.client.DebugInfoEventJS;
import dev.latvian.kubejs.client.TagInstance;
import dev.latvian.kubejs.client.painter.Painter;
import dev.latvian.kubejs.client.painter.screen.ScreenPaintEventJS;
import dev.latvian.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.kubejs.client.painter.world.WorldPaintEventJS;
import dev.latvian.kubejs.client.painter.world.WorldPainterObject;
import dev.latvian.kubejs.core.BucketItemKJS;
import dev.latvian.kubejs.core.ImageButtonKJS;
import dev.latvian.kubejs.fluid.FluidBuilder;
import dev.latvian.kubejs.item.ItemBuilder;
import dev.latvian.kubejs.item.ItemTooltipEventJS;
import dev.latvian.kubejs.item.OldItemTooltipEventJS;
import dev.latvian.kubejs.player.AttachPlayerDataEvent;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.Tags;
import dev.latvian.kubejs.world.AttachWorldDataEvent;
import dev.latvian.kubejs.world.ClientWorldJS;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.imageio.ImageIO;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.TextureStitchEvent;
import me.shedaniel.architectury.event.events.TooltipEvent;
import me.shedaniel.architectury.event.events.client.ClientLifecycleEvent;
import me.shedaniel.architectury.event.events.client.ClientPlayerEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.hooks.ScreenHooks;
import me.shedaniel.architectury.registry.ColorHandlers;
import me.shedaniel.architectury.registry.RenderTypes;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class KubeJSClientEventHandler {
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE = new ResourceLocation("textures/gui/recipe_button.png");
    public static Map<Item, List<ItemTooltipEventJS.StaticTooltipHandler>> staticItemTooltips = null;
    private final Map<ResourceLocation, TagInstance> tempTagNames = new LinkedHashMap<ResourceLocation, TagInstance>();

    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::clientSetup);
        GuiEvent.DEBUG_TEXT_LEFT.register(this::debugInfoLeft);
        GuiEvent.DEBUG_TEXT_RIGHT.register(this::debugInfoRight);
        TooltipEvent.ITEM.register(this::itemTooltip);
        ClientTickEvent.CLIENT_POST.register(this::clientTick);
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(this::loggedIn);
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        ClientPlayerEvent.CLIENT_PLAYER_RESPAWN.register(this::respawn);
        GuiEvent.RENDER_HUD.register(this::inGameScreenDraw);
        GuiEvent.RENDER_POST.register(this::guiScreenDraw);
        GuiEvent.INIT_POST.register(this::guiPostInit);
        TextureStitchEvent.POST.register(this::postAtlasStitch);
    }

    private void clientSetup(Minecraft minecraft) {
        this.renderLayers();
        this.blockColors();
        this.itemColors();
    }

    private void renderLayers() {
        for (BlockBuilder builder : KubeJSObjects.BLOCKS.values()) {
            switch (builder.renderType) {
                case "cutout": {
                    RenderTypes.register((RenderType)RenderType.func_228643_e_(), (Block[])new Block[]{builder.block});
                    break;
                }
                case "cutout_mipped": {
                    RenderTypes.register((RenderType)RenderType.func_228641_d_(), (Block[])new Block[]{builder.block});
                    break;
                }
                case "translucent": {
                    RenderTypes.register((RenderType)RenderType.func_228645_f_(), (Block[])new Block[]{builder.block});
                }
            }
        }
    }

    private void debugInfoLeft(List<String> lines) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            new DebugInfoEventJS(lines).post(ScriptType.CLIENT, "client.debug_info.left");
        }
    }

    private void debugInfoRight(List<String> lines) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            new DebugInfoEventJS(lines).post(ScriptType.CLIENT, "client.debug_info.right");
        }
    }

    private void itemTooltip(ItemStack stack, List<ITextComponent> lines, ITooltipFlag flag) {
        boolean advanced = flag.func_194127_a();
        if (advanced && ClientProperties.get().getShowTagNames() && Screen.func_231173_s_()) {
            for (ResourceLocation tag : Tags.byItemStack(stack)) {
                this.tempTagNames.computeIfAbsent((ResourceLocation)tag, (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.util.ResourceLocation ), (Lnet/minecraft/util/ResourceLocation;)Ldev/latvian/kubejs/client/TagInstance;)()).item = true;
            }
            if (stack.func_77973_b() instanceof BlockItem) {
                for (ResourceLocation tag : Tags.byBlock(((BlockItem)stack.func_77973_b()).func_179223_d())) {
                    this.tempTagNames.computeIfAbsent((ResourceLocation)tag, (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.util.ResourceLocation ), (Lnet/minecraft/util/ResourceLocation;)Ldev/latvian/kubejs/client/TagInstance;)()).block = true;
                }
            }
            if (stack.func_77973_b() instanceof BucketItemKJS) {
                for (ResourceLocation tag : Tags.byFluid(((BucketItemKJS)stack.func_77973_b()).getFluidKJS())) {
                    this.tempTagNames.computeIfAbsent((ResourceLocation)tag, (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.util.ResourceLocation ), (Lnet/minecraft/util/ResourceLocation;)Ldev/latvian/kubejs/client/TagInstance;)()).fluid = true;
                }
            }
            if (stack.func_77973_b() instanceof SpawnEggItem) {
                for (ResourceLocation tag : Tags.byEntityType(((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p()))) {
                    this.tempTagNames.computeIfAbsent((ResourceLocation)tag, (Function<ResourceLocation, TagInstance>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.util.ResourceLocation ), (Lnet/minecraft/util/ResourceLocation;)Ldev/latvian/kubejs/client/TagInstance;)()).entity = true;
                }
            }
            for (TagInstance instance : this.tempTagNames.values()) {
                lines.add(instance.toText());
            }
            this.tempTagNames.clear();
        }
        if (staticItemTooltips == null) {
            staticItemTooltips = new HashMap<Item, List<ItemTooltipEventJS.StaticTooltipHandler>>();
            new ItemTooltipEventJS(staticItemTooltips).post(ScriptType.CLIENT, "item.tooltip");
        }
        for (ItemTooltipEventJS.StaticTooltipHandler h : staticItemTooltips.getOrDefault(Items.field_190931_a, Collections.emptyList())) {
            h.tooltip(stack, advanced, lines);
        }
        for (ItemTooltipEventJS.StaticTooltipHandler h : staticItemTooltips.getOrDefault(stack.func_77973_b(), Collections.emptyList())) {
            h.tooltip(stack, advanced, lines);
        }
        new OldItemTooltipEventJS(stack, lines, advanced).post(ScriptType.CLIENT, "client.item_tooltip");
    }

    private void clientTick(Minecraft minecraft) {
        if (Minecraft.func_71410_x().field_71439_g != null && ClientWorldJS.getInstance() != null) {
            new ClientTickEventJS().post("client.tick");
        }
    }

    private void loggedIn(ClientPlayerEntity player) {
        ClientWorldJS.setInstance(new ClientWorldJS(Minecraft.func_71410_x(), player));
        new AttachWorldDataEvent(ClientWorldJS.getInstance()).invoke();
        new AttachPlayerDataEvent(ClientWorldJS.getInstance().clientPlayerData).invoke();
        new ClientLoggedInEventJS().post("client.logged_in");
    }

    private void loggedOut(ClientPlayerEntity player) {
        if (ClientWorldJS.getInstance() != null) {
            new ClientLoggedInEventJS().post("client.logged_out");
        }
        ClientWorldJS.setInstance(null);
        Painter.INSTANCE.clear();
    }

    private void respawn(ClientPlayerEntity oldPlayer, ClientPlayerEntity newPlayer) {
        ClientWorldJS.setInstance(new ClientWorldJS(Minecraft.func_71410_x(), newPlayer));
        new AttachWorldDataEvent(ClientWorldJS.getInstance()).invoke();
        new AttachPlayerDataEvent(ClientWorldJS.getInstance().clientPlayerData).invoke();
    }

    private void inGameScreenDraw(MatrixStack matrices, float delta) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71474_y.field_74330_P || mc.field_71462_r != null) {
            return;
        }
        RenderSystem.enableBlend();
        ScreenPaintEventJS event = new ScreenPaintEventJS(mc, matrices, delta);
        Painter.INSTANCE.deltaUnit.set(delta);
        Painter.INSTANCE.screenWidthUnit.set((float)event.width);
        Painter.INSTANCE.screenHeightUnit.set((float)event.height);
        Painter.INSTANCE.mouseXUnit.set((float)event.mouseX);
        Painter.INSTANCE.mouseYUnit.set((float)event.mouseY);
        event.post("client.paint_screen");
        for (ScreenPainterObject object : Painter.INSTANCE.getScreenObjects()) {
            if (!object.visible || object.draw != 0 && object.draw != 1) continue;
            object.preDraw(event);
        }
        for (ScreenPainterObject object : Painter.INSTANCE.getScreenObjects()) {
            if (!object.visible || object.draw != 0 && object.draw != 1) continue;
            object.draw(event);
        }
    }

    private void guiScreenDraw(Screen screen, MatrixStack matrices, int mouseX, int mouseY, float delta) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        RenderSystem.enableBlend();
        ScreenPaintEventJS event = new ScreenPaintEventJS(mc, screen, matrices, mouseX, mouseY, delta);
        event.post("client.paint_screen");
        for (ScreenPainterObject object : Painter.INSTANCE.getScreenObjects()) {
            if (!object.visible || object.draw != 0 && object.draw != 2) continue;
            object.preDraw(event);
        }
        for (ScreenPainterObject object : Painter.INSTANCE.getScreenObjects()) {
            if (!object.visible || object.draw != 0 && object.draw != 2) continue;
            object.draw(event);
        }
    }

    private boolean isOver(List<Widget> list, int x, int y) {
        for (Widget w : list) {
            if (!w.field_230694_p_ || x < w.field_230690_l_ || y < w.field_230691_m_ || x >= w.field_230690_l_ + w.func_230998_h_() || y >= w.field_230691_m_ + w.func_238483_d_()) continue;
            return true;
        }
        return false;
    }

    private void guiPostInit(Screen screen, List<Widget> widgets, List<IGuiEventListener> children) {
        if (ClientProperties.get().getDisableRecipeBook() && screen instanceof IRecipeShownListener) {
            Iterator<IGuiEventListener> iterator = children.iterator();
            while (iterator.hasNext()) {
                IGuiEventListener listener = iterator.next();
                if (!(listener instanceof Widget) || !(listener instanceof ImageButtonKJS) || !RECIPE_BUTTON_TEXTURE.equals((Object)((ImageButtonKJS)listener).getButtonTextureKJS())) continue;
                ScreenHooks.getButtons((Screen)screen).remove(listener);
                iterator.remove();
                return;
            }
        }
    }

    private void itemColors() {
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            if (itemBuilder.color.isEmpty()) continue;
            ColorHandlers.registerItemColors((stack, index) -> builder.color.get(index), (IItemProvider[])new IItemProvider[]{(IItemProvider)Objects.requireNonNull(itemBuilder.item, "Item " + itemBuilder.id + " is null!")});
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.itemBuilder == null || blockBuilder.color.isEmpty()) continue;
            ColorHandlers.registerItemColors((stack, index) -> builder.color.get(index), (IItemProvider[])new IItemProvider[]{(IItemProvider)Objects.requireNonNull(blockBuilder.itemBuilder.blockItem, "Block Item " + blockBuilder.id + " is null!")});
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            if (fluidBuilder.bucketColor == -1) continue;
            ColorHandlers.registerItemColors((stack, index) -> index == 1 ? builder.bucketColor : -1, (IItemProvider[])new IItemProvider[]{(IItemProvider)Objects.requireNonNull(fluidBuilder.bucketItem, "Bucket Item " + fluidBuilder.id + " is null!")});
        }
    }

    private void blockColors() {
        for (BlockBuilder builder : KubeJSObjects.BLOCKS.values()) {
            if (builder.color.isEmpty()) continue;
            ColorHandlers.registerBlockColors((state, world, pos, index) -> builder.color.get(index), (Block[])new Block[]{builder.block});
        }
    }

    private void postAtlasStitch(AtlasTexture atlas) {
        if (!ClientProperties.get().getExportAtlases()) {
            return;
        }
        GL11.glBindTexture((int)3553, (int)atlas.func_110552_b());
        int w = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int h = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        if (w <= 0 || h <= 0) {
            return;
        }
        BufferedImage image = new BufferedImage(w, h, 2);
        int[] pixels = new int[w * h];
        IntBuffer result = BufferUtils.createIntBuffer((int)(w * h));
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (IntBuffer)result);
        result.get(pixels);
        image.setRGB(0, 0, w, h, pixels, 0, w);
        Path path = KubeJSPaths.EXPORTED.resolve(atlas.func_229223_g_().func_110624_b() + "/" + atlas.func_229223_g_().func_110623_a());
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
            ImageIO.write((RenderedImage)image, "PNG", stream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void renderWorldLast(MatrixStack ps, float delta) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        WorldPaintEventJS event = new WorldPaintEventJS(mc, ps, delta);
        event.post("client.paint_world");
        for (WorldPainterObject object : Painter.INSTANCE.getWorldObjects()) {
            if (!object.visible) continue;
            object.preDraw(event);
        }
        for (WorldPainterObject object : Painter.INSTANCE.getWorldObjects()) {
            if (!object.visible) continue;
            object.draw(event);
        }
    }
}

