/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block;

import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;

public abstract class BlockStatePredicate {
    public static final ResourceLocation AIR_ID = new ResourceLocation("minecraft:air");

    public static BlockStatePredicate parse(String s) {
        if (s.startsWith("#")) {
            ITag tag = TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(new ResourceLocation(s.substring(1)));
            if (tag != null) {
                return new FromTag((ITag<Block>)tag);
            }
        } else if (s.indexOf(91) != -1) {
            BlockState state = UtilsJS.parseBlockState(s);
            if (state != Blocks.field_150350_a.func_176223_P()) {
                return new FromState(state);
            }
        } else {
            Block block = (Block)KubeJSRegistries.blocks().get(new ResourceLocation(s));
            if (block != Blocks.field_150350_a) {
                return new FromID(block);
            }
        }
        return Empty.INSTANCE;
    }

    public static BlockStatePredicate of(Object blocks) {
        FromList predicate = new FromList();
        for (Object o : ListJS.orSelf(blocks)) {
            BlockStatePredicate p = BlockStatePredicate.of0(o);
            if (p == Empty.INSTANCE) continue;
            predicate.list.add(p);
        }
        return predicate.list.size() == 1 ? predicate.list.get(0) : (predicate.list.isEmpty() ? Empty.INSTANCE : predicate);
    }

    private static BlockStatePredicate of0(Object o) {
        if (o instanceof Block) {
            return new FromID((Block)o);
        }
        if (o instanceof BlockState) {
            return new FromState((BlockState)o);
        }
        if (o instanceof ITag) {
            return new FromTag((ITag<Block>)((ITag)o));
        }
        Pattern pattern = UtilsJS.parseRegex(o);
        return pattern == null ? BlockStatePredicate.parse(o.toString()) : new FromRegex(pattern);
    }

    public abstract boolean check(BlockState var1);

    public abstract Collection<Block> getBlocks();

    public Collection<BlockState> getBlockStates() {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        for (Block block : this.getBlocks()) {
            states.addAll((Collection<BlockState>)block.func_176194_O().func_177619_a());
        }
        return states;
    }

    public Set<ResourceLocation> getBlockIds() {
        LinkedHashSet<ResourceLocation> set = new LinkedHashSet<ResourceLocation>();
        for (Block block : this.getBlocks()) {
            ResourceLocation blockId = KubeJSRegistries.blocks().getId((Object)block);
            if (blockId == null) continue;
            set.add(blockId);
        }
        return set;
    }

    public static class FromTag
    extends BlockStatePredicate {
        public final ITag<Block> tag;

        public FromTag(ITag<Block> t) {
            this.tag = t;
        }

        @Override
        public boolean check(BlockState state) {
            return this.tag.func_230235_a_((Object)state.func_177230_c());
        }

        @Override
        public Collection<Block> getBlocks() {
            return this.tag.func_230236_b_();
        }
    }

    public static class FromState
    extends BlockStatePredicate {
        public final BlockState state;

        public FromState(BlockState s) {
            this.state = s;
        }

        @Override
        public boolean check(BlockState s) {
            return this.state == s;
        }

        @Override
        public Collection<Block> getBlocks() {
            return Collections.singleton(this.state.func_177230_c());
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            return Collections.singleton(this.state);
        }

        @Override
        public Set<ResourceLocation> getBlockIds() {
            ResourceLocation blockId = KubeJSRegistries.blocks().getId((Object)this.state.func_177230_c());
            return blockId == null ? Collections.emptySet() : Collections.singleton(blockId);
        }
    }

    public static class FromID
    extends BlockStatePredicate {
        public final Block block;

        public FromID(Block b) {
            this.block = b;
        }

        @Override
        public boolean check(BlockState state) {
            return state.func_203425_a(this.block);
        }

        @Override
        public Collection<Block> getBlocks() {
            return Collections.singleton(this.block);
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            return this.block.func_176194_O().func_177619_a();
        }

        @Override
        public Set<ResourceLocation> getBlockIds() {
            ResourceLocation blockId = KubeJSRegistries.blocks().getId((Object)this.block);
            return blockId == null ? Collections.emptySet() : Collections.singleton(blockId);
        }
    }

    public static class Empty
    extends BlockStatePredicate {
        public static final Empty INSTANCE = new Empty();

        @Override
        public boolean check(BlockState state) {
            return false;
        }

        @Override
        public Collection<Block> getBlocks() {
            return Collections.emptyList();
        }

        @Override
        public Set<ResourceLocation> getBlockIds() {
            return Collections.emptySet();
        }
    }

    public static class FromList
    extends BlockStatePredicate {
        public final List<BlockStatePredicate> list = new ArrayList<BlockStatePredicate>();

        @Override
        public boolean check(BlockState state) {
            for (BlockStatePredicate predicate : this.list) {
                if (!predicate.check(state)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<Block> getBlocks() {
            HashSet<Block> set = new HashSet<Block>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlocks());
            }
            return set;
        }

        @Override
        public Collection<BlockState> getBlockStates() {
            HashSet<BlockState> set = new HashSet<BlockState>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlockStates());
            }
            return set;
        }

        @Override
        public Set<ResourceLocation> getBlockIds() {
            LinkedHashSet<ResourceLocation> set = new LinkedHashSet<ResourceLocation>();
            for (BlockStatePredicate predicate : this.list) {
                set.addAll(predicate.getBlockIds());
            }
            return set;
        }
    }

    public static class FromRegex
    extends BlockStatePredicate {
        public final Pattern pattern;
        private final LinkedHashSet<Block> matchedBlocks;

        public FromRegex(Pattern p) {
            this.pattern = p;
            this.matchedBlocks = new LinkedHashSet();
            for (Map.Entry entry : KubeJSRegistries.blocks().entrySet()) {
                if (!this.pattern.matcher(((RegistryKey)entry.getKey()).func_240901_a_().toString()).find()) continue;
                this.matchedBlocks.add((Block)entry.getValue());
            }
        }

        @Override
        public boolean check(BlockState state) {
            return this.matchedBlocks.contains(state.func_177230_c());
        }

        @Override
        public Collection<Block> getBlocks() {
            return this.matchedBlocks;
        }
    }
}

