/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block;

import com.google.gson.JsonObject;
import dev.latvian.kubejs.block.BlockItemBuilder;
import dev.latvian.kubejs.block.MaterialJS;
import dev.latvian.kubejs.block.MaterialListJS;
import dev.latvian.kubejs.block.RandomTickCallbackJS;
import dev.latvian.kubejs.block.custom.BasicBlockType;
import dev.latvian.kubejs.block.custom.BlockType;
import dev.latvian.kubejs.loot.LootBuilder;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.util.BuilderBase;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.architectury.registry.BlockProperties;
import me.shedaniel.architectury.registry.ToolType;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import org.jetbrains.annotations.Nullable;

public class BlockBuilder
extends BuilderBase {
    public static BlockBuilder current;
    public transient BlockType type = BasicBlockType.INSTANCE;
    public transient MaterialJS material;
    public transient float hardness;
    public transient float resistance;
    public transient float lightLevel;
    public transient ToolType harvestTool;
    public transient int harvestLevel;
    public transient boolean opaque;
    public transient boolean fullBlock;
    public transient boolean requiresTool;
    public transient String renderType;
    public transient Int2IntOpenHashMap color;
    public final transient JsonObject textures;
    public transient String model;
    public transient BlockItemBuilder itemBuilder;
    public transient List<AxisAlignedBB> customShape;
    public transient boolean noCollission;
    public transient boolean notSolid;
    public transient boolean waterlogged;
    public transient float slipperiness = 0.6f;
    public transient float speedFactor = 1.0f;
    public transient float jumpFactor = 1.0f;
    public Consumer<RandomTickCallbackJS> randomTickCallback;
    public Consumer<LootBuilder> lootTable;
    public JsonObject blockstateJson;
    public JsonObject modelJson;
    public transient boolean noValidSpawns;
    public transient boolean suffocating;
    public transient boolean viewBlocking;
    public transient boolean redstoneConductor;
    public transient boolean transparent;
    public transient Set<String> defaultTags;
    public transient Block block;

    public BlockBuilder(String i) {
        super(i);
        this.material = MaterialListJS.INSTANCE.map.get("wood");
        this.hardness = 0.5f;
        this.resistance = -1.0f;
        this.lightLevel = 0.0f;
        this.harvestTool = null;
        this.harvestLevel = -1;
        this.opaque = true;
        this.fullBlock = false;
        this.requiresTool = false;
        this.renderType = "solid";
        this.color = new Int2IntOpenHashMap();
        this.color.defaultReturnValue(-1);
        this.textures = new JsonObject();
        this.textureAll(this.id.func_110624_b() + ":block/" + this.id.func_110623_a());
        this.model = "";
        this.itemBuilder = new BlockItemBuilder(i);
        this.itemBuilder.blockBuilder = this;
        this.customShape = new ArrayList<AxisAlignedBB>();
        this.noCollission = false;
        this.notSolid = false;
        this.waterlogged = false;
        this.randomTickCallback = null;
        this.lootTable = loot -> loot.addPool(pool -> {
            pool.survivesExplosion();
            pool.addItem(new ItemStack((IItemProvider)this.block));
        });
        this.blockstateJson = null;
        this.modelJson = null;
        this.noValidSpawns = false;
        this.suffocating = true;
        this.viewBlocking = true;
        this.redstoneConductor = true;
        this.transparent = false;
        this.defaultTags = new HashSet<String>();
    }

    @Override
    public String getBuilderType() {
        return "block";
    }

    public BlockBuilder type(BlockType t) {
        this.type = t;
        this.type.applyDefaults(this);
        return this;
    }

    public BlockBuilder material(MaterialJS m) {
        this.material = m;
        return this;
    }

    public BlockBuilder hardness(float h) {
        this.hardness = h;
        return this;
    }

    public BlockBuilder resistance(float r) {
        this.resistance = r;
        return this;
    }

    public BlockBuilder unbreakable() {
        this.hardness = -1.0f;
        this.resistance = Float.MAX_VALUE;
        return this;
    }

    public BlockBuilder lightLevel(float light) {
        this.lightLevel = light;
        return this;
    }

    public BlockBuilder harvestTool(ToolType tool, int level) {
        this.harvestTool = tool;
        this.harvestLevel = level;
        return this;
    }

    public BlockBuilder opaque(boolean o) {
        this.opaque = o;
        return this;
    }

    public BlockBuilder fullBlock(boolean f) {
        this.fullBlock = f;
        return this;
    }

    public BlockBuilder requiresTool(boolean f) {
        this.requiresTool = f;
        return this;
    }

    public BlockBuilder renderType(String l) {
        this.renderType = l;
        return this;
    }

    public BlockBuilder color(int index, int c) {
        this.color.put(index, 0xFF000000 | c);
        return this;
    }

    @Deprecated
    public BlockBuilder texture(String tex) {
        ScriptType.STARTUP.console.warn("Using 'texture(tex)' in block builders is deprecated! Please use 'textureAll(tex)' instead!");
        return this.textureAll(tex);
    }

    public BlockBuilder textureAll(String tex) {
        for (Direction direction : Direction.values()) {
            this.textureSide(direction, tex);
        }
        this.textures.addProperty("particle", tex);
        return this;
    }

    public BlockBuilder textureSide(Direction direction, String tex) {
        return this.texture(direction.func_176610_l(), tex);
    }

    public BlockBuilder texture(String id, String tex) {
        this.textures.addProperty(id, tex);
        return this;
    }

    public BlockBuilder model(String m) {
        this.itemBuilder.parentModel = this.model = m;
        return this;
    }

    public BlockBuilder item(@Nullable Consumer<BlockItemBuilder> i) {
        if (i == null) {
            this.itemBuilder = null;
            this.lootTable = null;
        } else {
            i.accept(this.itemBuilder);
        }
        return this;
    }

    public BlockBuilder noItem() {
        return this.item(null);
    }

    @Deprecated
    public BlockBuilder shapeCube(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.box(x0, y0, z0, x1, y1, z1, true);
    }

    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1, boolean scale16) {
        if (scale16) {
            this.customShape.add(new AxisAlignedBB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0));
        } else {
            this.customShape.add(new AxisAlignedBB(x0, y0, z0, x1, y1, z1));
        }
        return this;
    }

    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.box(x0, y0, z0, x1, y1, z1, true);
    }

    public VoxelShape createShape() {
        if (this.customShape.isEmpty()) {
            return VoxelShapes.func_197868_b();
        }
        VoxelShape shape = VoxelShapes.func_197881_a((AxisAlignedBB)this.customShape.get(0));
        for (int i = 1; i < this.customShape.size(); ++i) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)this.customShape.get(i)));
        }
        return shape;
    }

    public BlockBuilder noCollission() {
        this.noCollission = true;
        return this;
    }

    public BlockBuilder notSolid() {
        this.notSolid = true;
        return this;
    }

    public BlockBuilder waterlogged() {
        this.waterlogged = true;
        return this;
    }

    public BlockBuilder noDrops() {
        this.lootTable = null;
        return this;
    }

    public BlockBuilder slipperiness(float f) {
        this.slipperiness = f;
        return this;
    }

    public BlockBuilder speedFactor(float f) {
        this.speedFactor = f;
        return this;
    }

    public BlockBuilder jumpFactor(float f) {
        this.jumpFactor = f;
        return this;
    }

    public BlockBuilder randomTick(@Nullable Consumer<RandomTickCallbackJS> randomTickCallback) {
        this.randomTickCallback = randomTickCallback;
        return this;
    }

    public BlockBuilder noValidSpawns(boolean b) {
        this.noValidSpawns = b;
        return this;
    }

    public BlockBuilder suffocating(boolean b) {
        this.suffocating = b;
        return this;
    }

    public BlockBuilder viewBlocking(boolean b) {
        this.viewBlocking = b;
        return this;
    }

    public BlockBuilder redstoneConductor(boolean b) {
        this.redstoneConductor = b;
        return this;
    }

    public BlockBuilder transparent(boolean b) {
        this.transparent = b;
        return this;
    }

    public BlockBuilder defaultCutout() {
        return this.renderType("cutout").notSolid().noValidSpawns(true).suffocating(false).viewBlocking(false).redstoneConductor(false).transparent(true);
    }

    public BlockBuilder defaultTranslucent() {
        return this.defaultCutout().renderType("translucent");
    }

    public BlockBuilder tag(String tag) {
        this.defaultTags.add(tag);
        return this;
    }

    public BlockBuilder tagBlockAndItem(String tag) {
        this.defaultTags.add(tag);
        this.itemBuilder.defaultTags.add(tag);
        return this;
    }

    public AbstractBlock.Properties createProperties() {
        BlockProperties properties = BlockProperties.of((Material)this.material.getMinecraftMaterial());
        properties.func_200947_a(this.material.getSound());
        if (this.resistance >= 0.0f) {
            properties.func_200948_a(this.hardness, this.resistance);
        } else {
            properties.func_200943_b(this.hardness);
        }
        properties.func_235838_a_(state -> (int)(this.lightLevel * 15.0f));
        if (this.harvestTool != null && this.harvestLevel >= 0) {
            properties.tool(this.harvestTool, this.harvestLevel);
        }
        if (this.noCollission) {
            properties.func_200942_a();
        }
        if (this.notSolid) {
            properties.func_226896_b_();
        }
        if (this.requiresTool) {
            properties.func_235861_h_();
        }
        if (this.lootTable == null) {
            properties.func_222380_e();
        }
        properties.func_200941_a(this.slipperiness);
        properties.func_226897_b_(this.speedFactor);
        properties.func_226898_c_(this.jumpFactor);
        if (this.noValidSpawns) {
            properties.func_235827_a_((blockState, blockGetter, blockPos, object) -> false);
        }
        if (!this.suffocating) {
            properties.func_235842_b_((blockState, blockGetter, blockPos) -> false);
        }
        if (!this.viewBlocking) {
            properties.func_235847_c_((blockState, blockGetter, blockPos) -> false);
        }
        if (!this.redstoneConductor) {
            properties.func_235828_a_((blockState, blockGetter, blockPos) -> false);
        }
        if (this.randomTickCallback != null) {
            properties.func_200944_c();
        }
        return properties;
    }
}

