/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world.gen;

import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.event.StartupEventJS;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.gen.AddLakeProperties;
import dev.latvian.kubejs.world.gen.AddOreProperties;
import dev.latvian.kubejs.world.gen.AddSpawnProperties;
import dev.latvian.kubejs.world.gen.AnyRuleTest;
import dev.latvian.kubejs.world.gen.InvertRuleTest;
import dev.latvian.kubejs.world.gen.WorldgenEntryList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.BlockStateMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;

public class WorldgenAddEventJS
extends StartupEventJS {
    private static final Pattern SPAWN_PATTERN = Pattern.compile("(\\w+:\\w+)\\*\\((\\d+)-(\\d+)\\):(\\d+)");

    protected void addFeature(GenerationStage.Decoration decoration, ConfiguredFeature<?, ?> configuredFeature) {
    }

    protected void addEntitySpawn(EntityClassification category, MobSpawnInfo.Spawners spawnerData) {
    }

    protected boolean verifyBiomes(WorldgenEntryList biomes) {
        return true;
    }

    public boolean isInBiomes(String[] filter) {
        WorldgenEntryList list = new WorldgenEntryList();
        list.blacklist = false;
        list.values.addAll(Arrays.asList(filter));
        return this.verifyBiomes(list);
    }

    public boolean isNotInBiomes(String[] filter) {
        WorldgenEntryList list = new WorldgenEntryList();
        list.blacklist = true;
        list.values.addAll(Arrays.asList(filter));
        return this.verifyBiomes(list);
    }

    public void addOre(Consumer<AddOreProperties> p) {
        AddOreProperties properties = new AddOreProperties();
        p.accept(properties);
        if (properties._block == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        if (!this.verifyBiomes(properties.biomes)) {
            return;
        }
        AnyRuleTest ruleTest = new AnyRuleTest();
        for (Object o : ListJS.orSelf(properties.spawnsIn.values)) {
            String s = String.valueOf(o);
            boolean invert = false;
            while (s.startsWith("!")) {
                s = s.substring(1);
                invert = !invert;
            }
            if (s.startsWith("#")) {
                TagMatchRuleTest tagTest = new TagMatchRuleTest(TagCollectionManager.func_242178_a().func_241835_a().func_199910_a(new ResourceLocation(s.substring(1))));
                ruleTest.list.add(invert ? new InvertRuleTest((RuleTest)tagTest) : tagTest);
                continue;
            }
            BlockState bs = UtilsJS.parseBlockState(s);
            BlockStateMatchRuleTest tagTest = s.indexOf(91) != -1 ? new BlockStateMatchRuleTest(bs) : new BlockMatchRuleTest(bs.func_177230_c());
            ruleTest.list.add(invert ? new InvertRuleTest((RuleTest)tagTest) : tagTest);
        }
        RuleTest ruleTest1 = ruleTest.list.isEmpty() ? OreFeatureConfig.FillerBlockType.field_241882_a : ruleTest;
        ConfiguredFeature oreConfig = (properties.noSurface ? Feature.field_236289_V_ : Feature.field_202290_aj).func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)(properties.spawnsIn.blacklist ? new InvertRuleTest(ruleTest1) : ruleTest1), properties._block, properties.clusterMaxSize));
        oreConfig = (ConfiguredFeature)UtilsJS.cast(oreConfig.func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(properties.minHeight, 0, properties.maxHeight))));
        oreConfig = (ConfiguredFeature)UtilsJS.cast(oreConfig.func_242730_a(FeatureSpread.func_242253_a((int)properties.clusterMinCount, (int)(properties.clusterMaxCount - properties.clusterMinCount))));
        if (properties.chance > 0) {
            oreConfig = (ConfiguredFeature)UtilsJS.cast(oreConfig.func_242729_a(properties.chance));
        }
        if (properties.squared) {
            oreConfig = (ConfiguredFeature)UtilsJS.cast(oreConfig.func_242728_a());
        }
        this.addFeature(properties._worldgenLayer, oreConfig);
    }

    public void addLake(Consumer<AddLakeProperties> p) {
        AddLakeProperties properties = new AddLakeProperties();
        p.accept(properties);
        if (properties._block == Blocks.field_150350_a.func_176223_P()) {
            return;
        }
        if (!this.verifyBiomes(properties.biomes)) {
            return;
        }
        this.addFeature(properties._worldgenLayer, Feature.field_202289_ai.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(properties._block)).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig(properties.chance))));
    }

    public void addSpawn(Consumer<AddSpawnProperties> p) {
        AddSpawnProperties properties = new AddSpawnProperties();
        p.accept(properties);
        if (properties._entity == null || properties._category == null) {
            return;
        }
        if (!this.verifyBiomes(properties.biomes)) {
            return;
        }
        this.addEntitySpawn(properties._category, new MobSpawnInfo.Spawners(properties._entity, properties.weight, properties.minCount, properties.maxCount));
    }

    public void addSpawn(EntityClassification category, String spawn) {
        Matcher matcher = SPAWN_PATTERN.matcher(spawn);
        if (matcher.matches()) {
            try {
                this.addEntitySpawn(category, new MobSpawnInfo.Spawners(Objects.requireNonNull((EntityType)KubeJSRegistries.entityTypes().get(new ResourceLocation(matcher.group(1)))), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3))));
            }
            catch (Exception ex) {
                ConsoleJS.STARTUP.info("Failed to add spawn: " + ex);
            }
        } else {
            ConsoleJS.STARTUP.info("Invalid spawn syntax! Must be mod:entity_type*(minCount-maxCount):weight");
        }
    }
}

