/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.entity.ItemEntityJS;
import dev.latvian.kubejs.entity.ItemFrameEntityJS;
import dev.latvian.kubejs.entity.LivingEntityJS;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.player.PlayerDataJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.player.ServerPlayerJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.GameRulesJS;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.util.AttachedData;
import dev.latvian.kubejs.util.WithAttachedData;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.ExplosionJS;
import dev.latvian.kubejs.world.FireworksJS;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public abstract class WorldJS
implements WithAttachedData {
    public final World minecraftLevel;
    public final World minecraftWorld;
    private AttachedData data;

    public WorldJS(World w) {
        this.minecraftLevel = w;
        this.minecraftWorld = w;
    }

    public abstract ScriptType getSide();

    @Override
    public AttachedData getData() {
        if (this.data == null) {
            this.data = new AttachedData(this);
        }
        return this.data;
    }

    public GameRulesJS getGameRules() {
        return new GameRulesJS(this.minecraftLevel.func_82736_K());
    }

    @Nullable
    public ServerJS getServer() {
        return null;
    }

    public long getTime() {
        return this.minecraftLevel.func_82737_E();
    }

    public long getLocalTime() {
        return this.minecraftLevel.func_72820_D();
    }

    public String getDimension() {
        return this.minecraftLevel.func_234923_W_().func_240901_a_().toString();
    }

    public boolean isOverworld() {
        return this.minecraftLevel.func_234923_W_() == World.field_234918_g_;
    }

    public boolean isDaytime() {
        return this.minecraftLevel.func_72935_r();
    }

    public boolean isRaining() {
        return this.minecraftLevel.func_72896_J();
    }

    public boolean isThundering() {
        return this.minecraftLevel.func_72911_I();
    }

    public void setRainStrength(float strength) {
        this.minecraftLevel.func_72894_k(strength);
    }

    public BlockContainerJS getBlock(int x, int y, int z) {
        return this.getBlock(new BlockPos(x, y, z));
    }

    public BlockContainerJS getBlock(BlockPos pos) {
        return new BlockContainerJS(this.minecraftLevel, pos);
    }

    public BlockContainerJS getBlock(TileEntity blockEntity) {
        return this.getBlock(blockEntity.func_174877_v());
    }

    public abstract PlayerDataJS getPlayerData(PlayerEntity var1);

    @Nullable
    public EntityJS getEntity(@Nullable Entity e) {
        if (e == null) {
            return null;
        }
        if (e instanceof PlayerEntity) {
            return this.getPlayerData((PlayerEntity)e).getPlayer();
        }
        if (e instanceof LivingEntity) {
            return new LivingEntityJS(this, (LivingEntity)e);
        }
        if (e instanceof ItemEntity) {
            return new ItemEntityJS(this, (ItemEntity)e);
        }
        if (e instanceof ItemFrameEntity) {
            return new ItemFrameEntityJS(this, (ItemFrameEntity)e);
        }
        return new EntityJS(this, e);
    }

    @Nullable
    public LivingEntityJS getLivingEntity(@Nullable Entity entity) {
        EntityJS e = this.getEntity(entity);
        return e instanceof LivingEntityJS ? (LivingEntityJS)e : null;
    }

    @Nullable
    public PlayerJS getPlayer(@Nullable Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return null;
        }
        EntityJS e = this.getEntity(entity);
        return e instanceof PlayerJS ? (PlayerJS)e : null;
    }

    public EntityArrayList createEntityList(Collection<? extends Entity> entities) {
        return new EntityArrayList(this, entities);
    }

    public EntityArrayList getPlayers() {
        return this.createEntityList(this.minecraftLevel.func_217369_A());
    }

    public EntityArrayList getEntities() {
        return new EntityArrayList(this, 0);
    }

    public ExplosionJS createExplosion(double x, double y, double z) {
        return new ExplosionJS((IWorld)this.minecraftLevel, x, y, z);
    }

    @Nullable
    public EntityJS createEntity(ResourceLocation id) {
        EntityType type = (EntityType)Registry.field_212629_r.func_82594_a(id);
        if (type == null) {
            return null;
        }
        return this.getEntity(type.func_200721_a(this.minecraftLevel));
    }

    public void spawnLightning(double x, double y, double z, boolean effectOnly, @Nullable EntityJS player) {
        if (this.minecraftLevel instanceof ServerWorld) {
            LightningBoltEntity e = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.minecraftLevel);
            e.func_225653_b_(x, y, z);
            e.func_204809_d(player instanceof ServerPlayerJS ? (ServerPlayerEntity)((ServerPlayerJS)player).minecraftPlayer : null);
            this.minecraftLevel.func_217376_c((Entity)e);
        }
    }

    public void spawnLightning(double x, double y, double z, boolean effectOnly) {
        this.spawnLightning(x, y, z, effectOnly, null);
    }

    public void spawnFireworks(double x, double y, double z, FireworksJS f) {
        this.minecraftLevel.func_217376_c((Entity)f.createFireworkRocket(this.minecraftLevel, x, y, z));
    }

    public EntityArrayList getEntitiesWithin(AxisAlignedBB aabb) {
        return new EntityArrayList(this, this.minecraftLevel.func_72839_b(null, aabb));
    }
}

