/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.world.AttachWorldDataEvent;
import dev.latvian.kubejs.world.ExplosionEventJS;
import dev.latvian.kubejs.world.ServerWorldJS;
import dev.latvian.kubejs.world.SimpleWorldEventJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.List;
import me.shedaniel.architectury.event.events.ExplosionEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.event.events.TickEvent;
import net.minecraft.entity.Entity;
import net.minecraft.util.ActionResultType;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class KubeJSWorldEventHandler {
    public static void init() {
        LifecycleEvent.SERVER_WORLD_LOAD.register(KubeJSWorldEventHandler::worldLoaded);
        LifecycleEvent.SERVER_WORLD_UNLOAD.register(KubeJSWorldEventHandler::worldUnloaded);
        TickEvent.SERVER_WORLD_POST.register(KubeJSWorldEventHandler::worldTick);
        ExplosionEvent.PRE.register(KubeJSWorldEventHandler::explosionStart);
        ExplosionEvent.DETONATE.register(KubeJSWorldEventHandler::explosionDetonate);
    }

    private static void worldLoaded(ServerWorld level) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && !ServerJS.instance.levelMap.containsKey(level.func_234923_W_().func_240901_a_().toString())) {
            ServerWorldJS w = new ServerWorldJS(ServerJS.instance, level);
            ServerJS.instance.levelMap.put(level.func_234923_W_().func_240901_a_().toString(), w);
            ServerJS.instance.updateWorldList();
            new AttachWorldDataEvent(w).invoke();
            new SimpleWorldEventJS(w).post(ScriptType.SERVER, "world.load");
        }
    }

    private static void worldUnloaded(ServerWorld level) {
        if (ServerJS.instance != null && ServerJS.instance.overworld != null && ServerJS.instance.levelMap.containsKey(level.func_234923_W_().func_240901_a_().toString())) {
            WorldJS w = ServerJS.instance.getLevel((World)level);
            new SimpleWorldEventJS(w).post(ScriptType.SERVER, "world.unload");
            ServerJS.instance.levelMap.remove(w.getDimension());
            ServerJS.instance.updateWorldList();
        }
    }

    private static void worldTick(ServerWorld level) {
        WorldJS w = ServerJS.instance.getLevel((World)level);
        new SimpleWorldEventJS(w).post(ScriptType.SERVER, "world.tick");
    }

    private static ActionResultType explosionStart(World world, Explosion explosion) {
        if (new ExplosionEventJS.Pre(world, explosion).post("world.explosion.pre")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static void explosionDetonate(World world, Explosion explosion, List<Entity> affectedEntities) {
        new ExplosionEventJS.Post(world, explosion, affectedEntities).post("world.explosion.post");
    }
}

