/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.world;

import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.entity.LivingEntityJS;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.WorldEventJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.architectury.hooks.ExplosionHooks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public abstract class ExplosionEventJS
extends WorldEventJS {
    protected final World world;
    protected final Explosion explosion;

    public ExplosionEventJS(World world, Explosion explosion) {
        this.world = world;
        this.explosion = explosion;
    }

    @Override
    public WorldJS getWorld() {
        return this.worldOf(this.world);
    }

    public Vector3d getPosition() {
        return ExplosionHooks.getPosition((Explosion)this.explosion);
    }

    public double getX() {
        return this.getPosition().field_72450_a;
    }

    public double getY() {
        return this.getPosition().field_72448_b;
    }

    public double getZ() {
        return this.getPosition().field_72449_c;
    }

    public BlockContainerJS getBlock() {
        return new BlockContainerJS(this.world, new BlockPos(this.getPosition()));
    }

    @Nullable
    public LivingEntityJS getExploder() {
        return this.getWorld().getLivingEntity((Entity)this.explosion.func_94613_c());
    }

    public static class Post
    extends ExplosionEventJS {
        private final List<Entity> affectedEntities;

        public Post(World world, Explosion explosion, List<Entity> affectedEntities) {
            super(world, explosion);
            this.affectedEntities = affectedEntities;
        }

        public EntityArrayList getAffectedEntities() {
            return new EntityArrayList(this.getWorld(), this.affectedEntities);
        }

        public void removeAffectedEntity(EntityJS entity) {
            this.affectedEntities.remove(entity.minecraftEntity);
        }

        public void removeAllAffectedEntities() {
            this.affectedEntities.clear();
        }

        public List<BlockContainerJS> getAffectedBlocks() {
            ArrayList<BlockContainerJS> list = new ArrayList<BlockContainerJS>(this.explosion.func_180343_e().size());
            for (BlockPos pos : this.explosion.func_180343_e()) {
                list.add(new BlockContainerJS(this.world, pos));
            }
            return list;
        }

        public void removeAffectedBlock(BlockContainerJS block) {
            this.explosion.func_180343_e().remove(block.getPos());
        }

        public void removeAllAffectedBlocks() {
            this.explosion.func_180343_e().clear();
        }

        public void removeKnockback() {
            this.explosion.func_77277_b().clear();
        }
    }

    public static class Pre
    extends ExplosionEventJS {
        public Pre(World world, Explosion explosion) {
            super(world, explosion);
        }

        @Override
        public boolean canCancel() {
            return true;
        }

        public float getSize() {
            return ExplosionHooks.getRadius((Explosion)this.explosion);
        }

        public void setSize(float s) {
            ExplosionHooks.setRadius((Explosion)this.explosion, (float)s);
        }
    }
}

