/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.util.JsonUtilsJS;
import java.util.Objects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TextTranslate
extends Text {
    private static final Object[] NO_OBJECTS = new Object[0];
    private final String key;
    private final Object[] objects;

    public TextTranslate(String k, Object[] o) {
        this.key = k;
        this.objects = o;
        for (int i = 0; i < this.objects.length; ++i) {
            if (!(this.objects[i] instanceof ITextComponent) && (this.objects[i] instanceof Text || JsonUtilsJS.toPrimitive(JsonUtilsJS.of(this.objects[i])) != null)) continue;
            this.objects[i] = Text.of(this.objects[i]);
        }
    }

    public TextTranslate(String k) {
        this.key = k;
        this.objects = NO_OBJECTS;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getObjects() {
        return this.objects;
    }

    public TranslationTextComponent rawComponent() {
        Object[] o = new Object[this.objects.length];
        for (int i = 0; i < this.objects.length; ++i) {
            o[i] = this.objects[i] instanceof Text ? ((Text)this.objects[i]).component() : (this.objects[i] instanceof ITextComponent ? ((ITextComponent)this.objects[i]).func_230532_e_() : this.objects[i]);
        }
        return new TranslationTextComponent(this.key, o);
    }

    @Override
    public Text rawCopy() {
        Object[] o = new Object[this.objects.length];
        for (int i = 0; i < this.objects.length; ++i) {
            o[i] = this.objects[i] instanceof Text ? ((Text)this.objects[i]).copy() : (this.objects[i] instanceof ITextComponent ? ((ITextComponent)this.objects[i]).func_230532_e_() : this.objects[i]);
        }
        return new TextTranslate(this.key, o);
    }

    public JsonObject toJson() {
        JsonObject o = this.getStyleAndSiblingJson();
        o.addProperty("translate", this.key);
        if (this.objects.length > 0) {
            JsonArray array = new JsonArray();
            for (Object ob : this.objects) {
                array.add(JsonUtilsJS.of(ob));
            }
            o.add("with", (JsonElement)array);
        }
        return o;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TextTranslate) || !this.key.equals(((TextTranslate)obj).key)) {
            return false;
        }
        Object[] o = ((TextTranslate)obj).objects;
        if (this.objects.length == o.length) {
            for (int i = 0; i < this.objects.length; ++i) {
                if (Objects.equals(this.objects[i], o[i])) continue;
                return false;
            }
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return (this.key.hashCode() * 31 + Objects.hash(this.objects)) * 31 + super.hashCode();
    }
}

