/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.KubeJSPaths;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.core.TagBuilderKJS;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.item.ItemBuilder;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.UtilsJS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.shedaniel.architectury.registry.Registry;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class TagEventJS<T>
extends EventJS {
    private final String type;
    private final Map<ResourceLocation, ITag.Builder> map;
    private final Function<ResourceLocation, Optional<T>> registry;
    private Map<ResourceLocation, TagWrapper<T>> tags;
    private int addedCount;
    private int removedCount;
    private List<Predicate<String>> globalPriorityList;
    private Registry<T> actualRegistry;

    private static String getIdOfEntry(String s) {
        if (s.length() > 0 && s.charAt(s.length() - 1) == '?') {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    @Nullable
    private static List<Predicate<String>> parsePriorityList(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        ArrayList<Predicate<String>> list = new ArrayList<Predicate<String>>();
        for (Object o1 : ListJS.orSelf(o)) {
            String m;
            String s = String.valueOf(o1);
            if (s.startsWith("@")) {
                m = s.substring(1);
                list.add(id -> id.startsWith(m));
                continue;
            }
            if (s.startsWith("!@")) {
                m = s.substring(2);
                list.add(id -> !id.startsWith(m));
                continue;
            }
            list.add(id -> id.equals(s));
        }
        return list.isEmpty() ? null : list;
    }

    public TagEventJS(String t, Map<ResourceLocation, ITag.Builder> m, Function<ResourceLocation, Optional<T>> r) {
        this.type = t;
        this.map = m;
        this.registry = r;
        this.addedCount = 0;
        this.removedCount = 0;
        this.globalPriorityList = null;
        this.actualRegistry = null;
        switch (this.type) {
            case "items": {
                this.actualRegistry = (Registry)UtilsJS.cast(KubeJSRegistries.items());
                break;
            }
            case "blocks": {
                this.actualRegistry = (Registry)UtilsJS.cast(KubeJSRegistries.blocks());
                break;
            }
            case "fluids": {
                this.actualRegistry = (Registry)UtilsJS.cast(KubeJSRegistries.fluids());
                break;
            }
            case "entity_types": {
                this.actualRegistry = (Registry)UtilsJS.cast(KubeJSRegistries.entityTypes());
            }
        }
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void post(String event) {
        Path dumpFile = KubeJSPaths.EXPORTED.resolve("tags/" + this.type + ".txt");
        if (!Files.exists(dumpFile, new LinkOption[0])) {
            try {
                if (!Files.exists(dumpFile.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dumpFile.getParent(), new FileAttribute[0]);
                }
                ArrayList<String> lines = new ArrayList<String>();
                this.map.forEach((tagId, tagBuilder) -> {
                    lines.add("");
                    lines.add("#" + tagId);
                    tagBuilder.func_232962_b_().forEach(builderEntry -> lines.add("- " + builderEntry.func_232968_a_()));
                });
                lines.add(0, "To refresh this file, delete it and run /reload command again! Last updated: " + DateFormat.getDateTimeInstance().format(new Date()));
                Files.write(dumpFile, lines, new OpenOption[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.tags = new HashMap<ResourceLocation, TagWrapper<T>>();
        for (Map.Entry<ResourceLocation, ITag.Builder> entry : this.map.entrySet()) {
            TagWrapper tagWrapper = new TagWrapper(this, entry.getKey(), entry.getValue());
            this.tags.put(entry.getKey(), tagWrapper);
            ConsoleJS.SERVER.debug(this.type + "/#" + entry.getKey() + "; " + tagWrapper.proxyList.size());
        }
        if (this.type.equals("items")) {
            for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
                for (String s : itemBuilder.defaultTags) {
                    this.add(new ResourceLocation(s), itemBuilder.id);
                }
                for (BlockBuilder block : KubeJSObjects.BLOCKS.values()) {
                    if (block.itemBuilder == null) continue;
                    for (String s : block.itemBuilder.defaultTags) {
                        this.add(new ResourceLocation(s), block.itemBuilder.id);
                    }
                }
            }
        } else if (this.type.equals("blocks")) {
            for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
                for (String s : blockBuilder.defaultTags) {
                    this.add(new ResourceLocation(s), blockBuilder.id);
                }
            }
        }
        ConsoleJS.SERVER.setLineNumber(true);
        this.post(ScriptType.SERVER, event);
        ConsoleJS.SERVER.setLineNumber(false);
        int reordered = 0;
        for (TagWrapper<T> tagWrapper : this.tags.values()) {
            if (((TagWrapper)tagWrapper).priorityList == null) {
                ((TagWrapper)tagWrapper).priorityList = this.globalPriorityList;
            }
            if (((TagWrapper)tagWrapper).priorityList == null || !tagWrapper.sort()) continue;
            ++reordered;
        }
        if (ServerSettings.dataExport != null && this.actualRegistry != null) {
            void var4_15;
            JsonObject jsonObject;
            JsonObject jsonObject2 = ServerSettings.dataExport.getAsJsonObject("tags");
            if (jsonObject2 == null) {
                JsonObject jsonObject3 = new JsonObject();
                ServerSettings.dataExport.add("tags", (JsonElement)jsonObject3);
            }
            if ((jsonObject = var4_15.getAsJsonObject(this.type)) == null) {
                JsonObject jsonObject4 = new JsonObject();
                var4_15.add(this.type, (JsonElement)jsonObject4);
            }
            for (Map.Entry<ResourceLocation, ITag.Builder> entry : this.map.entrySet()) {
                void var5_27;
                JsonArray a = new JsonArray();
                entry.getValue().func_232962_b_().forEach(e -> a.add(e.func_232968_a_().toString()));
                var5_27.add(entry.getKey().toString(), (JsonElement)a);
            }
        }
        ConsoleJS.SERVER.info("[" + this.type + "] Found " + this.tags.size() + " tags, added " + this.addedCount + " objects, removed " + this.removedCount + " objects");
    }

    public TagWrapper<T> get(ResourceLocation id) {
        TagWrapper<T> t = this.tags.get(id);
        if (t == null) {
            t = new TagWrapper(this, id, ITag.Builder.func_200047_a());
            this.tags.put(id, t);
            this.map.put(id, ((TagWrapper)t).builder);
        }
        return t;
    }

    public TagWrapper<T> add(ResourceLocation tag, Object ids) {
        return this.get(tag).add(ids);
    }

    public TagWrapper<T> remove(ResourceLocation tag, Object ids) {
        return this.get(tag).remove(ids);
    }

    public TagWrapper<T> removeAll(ResourceLocation tag) {
        return this.get(tag).removeAll();
    }

    public void removeAllTagsFrom(Object ids) {
        for (Object o : ListJS.orSelf(ids)) {
            String id = String.valueOf(o);
            for (TagWrapper<T> tagWrapper : this.tags.values()) {
                ((TagWrapper)tagWrapper).proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.func_232968_a_().toString()).equals(id));
            }
        }
    }

    public void setGlobalPriorityList(@Nullable Object o) {
        this.globalPriorityList = TagEventJS.parsePriorityList(o);
    }

    public static class TagWrapper<T> {
        private final TagEventJS<T> event;
        private final ResourceLocation id;
        private final ITag.Builder builder;
        private final List<ITag.Proxy> proxyList;
        private List<Predicate<String>> priorityList;

        private TagWrapper(TagEventJS<T> e, ResourceLocation i, ITag.Builder t) {
            this.event = e;
            this.id = i;
            this.builder = t;
            this.proxyList = ((TagBuilderKJS)this.builder).getProxyListKJS();
            this.priorityList = null;
        }

        public String toString() {
            return ((TagEventJS)this.event).type + ":" + this.id;
        }

        public TagWrapper<T> add(Object ids) {
            for (Object o : ListJS.orSelf(ids)) {
                String s = String.valueOf(o);
                if (s.startsWith("#")) {
                    TagWrapper<T> w = this.event.get(new ResourceLocation(s.substring(1)));
                    this.builder.func_232964_b_(w.id, "kubejs");
                    ((TagEventJS)this.event).addedCount += w.proxyList.size();
                    if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                    ConsoleJS.SERVER.debug("+ " + this + " // " + w.id);
                    continue;
                }
                Pattern pattern = UtilsJS.parseRegex(s);
                if (pattern != null && ((TagEventJS)this.event).actualRegistry != null) {
                    for (ResourceLocation sid : ((TagEventJS)this.event).actualRegistry.getIds()) {
                        if (!pattern.matcher(sid.toString()).find()) continue;
                        Optional v = (Optional)((TagEventJS)this.event).registry.apply(sid);
                        if (v.isPresent()) {
                            this.builder.func_232961_a_(sid, "kubejs");
                            ((TagEventJS)this.event).addedCount++;
                            if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                            ConsoleJS.SERVER.debug("+ " + this + " // " + s + " [" + v.get().getClass().getName() + "]");
                            continue;
                        }
                        ConsoleJS.SERVER.error("+ " + this + " // " + s + " [Not found!]");
                    }
                    continue;
                }
                ResourceLocation sid = new ResourceLocation(s);
                Optional v = (Optional)((TagEventJS)this.event).registry.apply(sid);
                if (v.isPresent()) {
                    this.builder.func_232961_a_(sid, "kubejs");
                    ((TagEventJS)this.event).addedCount++;
                    if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                    ConsoleJS.SERVER.debug("+ " + this + " // " + s + " [" + v.get().getClass().getName() + "]");
                    continue;
                }
                ConsoleJS.SERVER.error("+ " + this + " // " + s + " [Not found!]");
            }
            return this;
        }

        public TagWrapper<T> remove(Object ids) {
            for (Object o : ListJS.orSelf(ids)) {
                String s = String.valueOf(o);
                if (s.startsWith("#")) {
                    TagWrapper<T> w = this.event.get(new ResourceLocation(s.substring(1)));
                    String entryId = w.id.toString();
                    int originalSize = this.proxyList.size();
                    this.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.func_232968_a_().toString()).equals(s));
                    int removedCount = this.proxyList.size() - originalSize;
                    if (removedCount == 0) {
                        if (!ServerSettings.instance.logSkippedRecipes) continue;
                        ConsoleJS.SERVER.warn(s + " didn't contain tag " + this + ", skipped");
                        continue;
                    }
                    ((TagEventJS)this.event).removedCount -= removedCount;
                    if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                    ConsoleJS.SERVER.debug("- " + this + " // " + w.id);
                    continue;
                }
                Pattern pattern = UtilsJS.parseRegex(s);
                if (pattern != null && ((TagEventJS)this.event).actualRegistry != null) {
                    for (ResourceLocation sid : ((TagEventJS)this.event).actualRegistry.getIds()) {
                        if (!pattern.matcher(sid.toString()).find()) continue;
                        Optional v = (Optional)((TagEventJS)this.event).registry.apply(sid);
                        if (v.isPresent()) {
                            int originalSize = this.proxyList.size();
                            this.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.func_232968_a_().toString()).equals(s));
                            int removedCount = this.proxyList.size() - originalSize;
                            if (removedCount == 0) {
                                if (!ServerSettings.instance.logSkippedRecipes) continue;
                                ConsoleJS.SERVER.warn(s + " didn't contain tag " + this.id + ", skipped");
                                continue;
                            }
                            ((TagEventJS)this.event).removedCount -= removedCount;
                            if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                            ConsoleJS.SERVER.debug("- " + this + " // " + s + " [" + v.get().getClass().getName() + "]");
                            continue;
                        }
                        ConsoleJS.SERVER.error("- " + this + " // " + s + " [Not found!]");
                    }
                    continue;
                }
                ResourceLocation sid = new ResourceLocation(s);
                Optional v = (Optional)((TagEventJS)this.event).registry.apply(sid);
                if (v.isPresent()) {
                    int originalSize = this.proxyList.size();
                    this.proxyList.removeIf(proxy -> TagEventJS.getIdOfEntry(proxy.func_232968_a_().toString()).equals(s));
                    int removedCount = this.proxyList.size() - originalSize;
                    if (removedCount == 0) {
                        if (!ServerSettings.instance.logSkippedRecipes) continue;
                        ConsoleJS.SERVER.warn(s + " didn't contain tag " + this.id + ", skipped");
                        continue;
                    }
                    ((TagEventJS)this.event).removedCount -= removedCount;
                    if (!ConsoleJS.SERVER.shouldPrintDebug()) continue;
                    ConsoleJS.SERVER.debug("- " + this + " // " + s + " [" + v.get().getClass().getName() + "]");
                    continue;
                }
                ConsoleJS.SERVER.error("- " + this + " // " + s + " [Not found!]");
            }
            return this;
        }

        public TagWrapper<T> removeAll() {
            if (ConsoleJS.SERVER.shouldPrintDebug()) {
                ConsoleJS.SERVER.debug("- " + this + " // (all)");
            }
            if (!this.proxyList.isEmpty()) {
                ((TagEventJS)this.event).removedCount += this.proxyList.size();
                this.proxyList.clear();
            } else if (ServerSettings.instance.logSkippedRecipes) {
                ConsoleJS.SERVER.warn("Tag " + this + " didn't contain any elements, skipped");
            }
            return this;
        }

        public void setPriorityList(@Nullable Object o) {
            this.priorityList = TagEventJS.parsePriorityList(o);
        }

        private void gatherAllItemIDs(HashSet<String> set, ITag.ITagEntry entry) {
            TagWrapper w;
            if (entry instanceof ITag.ItemEntry) {
                set.add(entry.toString());
            } else if (entry instanceof ITag.TagEntry && (w = (TagWrapper)((TagEventJS)this.event).tags.get(new ResourceLocation(entry.toString().substring(1)))) != null && w != this) {
                for (ITag.Proxy proxy : w.proxyList) {
                    this.gatherAllItemIDs(set, proxy.func_232968_a_());
                }
            }
        }

        public boolean sort() {
            ArrayList listOfLists = new ArrayList();
            for (int i = 0; i < this.priorityList.size() + 1; ++i) {
                listOfLists.add(new ArrayList());
            }
            for (ITag.Proxy proxy : this.proxyList) {
                boolean bl = false;
                HashSet<String> set = new HashSet<String>();
                this.gatherAllItemIDs(set, proxy.func_232968_a_());
                block2: for (String id : set) {
                    for (int i = 0; i < this.priorityList.size(); ++i) {
                        if (!this.priorityList.get(i).test(id)) continue;
                        ((List)listOfLists.get(i)).add(proxy);
                        bl = true;
                        continue block2;
                    }
                }
                if (bl) continue;
                ((List)listOfLists.get(this.priorityList.size())).add(proxy);
            }
            ArrayList<ITag.Proxy> proxyList0 = new ArrayList<ITag.Proxy>(this.proxyList);
            this.proxyList.clear();
            for (List list : listOfLists) {
                this.proxyList.addAll(list);
            }
            if (!proxyList0.equals(this.proxyList)) {
                if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("* Re-arranged " + this);
                }
                return true;
            }
            return false;
        }
    }
}

