/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import dev.latvian.kubejs.net.SendDataFromServerMessage;
import dev.latvian.kubejs.player.AdvancementJS;
import dev.latvian.kubejs.player.EntityArrayList;
import dev.latvian.kubejs.player.FakeServerPlayerDataJS;
import dev.latvian.kubejs.player.ServerPlayerDataJS;
import dev.latvian.kubejs.player.ServerPlayerJS;
import dev.latvian.kubejs.server.IScheduledEventCallback;
import dev.latvian.kubejs.server.ScheduledEvent;
import dev.latvian.kubejs.server.ServerScriptManager;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.util.AttachedData;
import dev.latvian.kubejs.util.MessageSender;
import dev.latvian.kubejs.util.WithAttachedData;
import dev.latvian.kubejs.world.AttachWorldDataEvent;
import dev.latvian.kubejs.world.ServerWorldJS;
import dev.latvian.kubejs.world.WorldJS;
import dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class ServerJS
implements MessageSender,
WithAttachedData {
    public static ServerJS instance;
    private MinecraftServer minecraftServer;
    public final transient ServerScriptManager serverScriptManager;
    public final transient List<ScheduledEvent> scheduledEvents;
    public final transient List<ScheduledEvent> scheduledTickEvents;
    public final transient Map<String, ServerWorldJS> levelMap;
    public final transient Map<UUID, ServerPlayerDataJS> playerMap;
    public final transient Map<UUID, FakeServerPlayerDataJS> fakePlayerMap;
    public final transient List<ServerWorldJS> worlds;
    public final CompoundNBT persistentData;
    public ServerWorldJS overworld;
    private AttachedData data;

    public ServerJS(MinecraftServer ms, ServerScriptManager m) {
        this.minecraftServer = ms;
        this.serverScriptManager = m;
        this.scheduledEvents = new LinkedList<ScheduledEvent>();
        this.scheduledTickEvents = new LinkedList<ScheduledEvent>();
        this.levelMap = new HashMap<String, ServerWorldJS>();
        this.playerMap = new HashMap<UUID, ServerPlayerDataJS>();
        this.fakePlayerMap = new HashMap<UUID, FakeServerPlayerDataJS>();
        this.worlds = new ArrayList<ServerWorldJS>();
        this.persistentData = new CompoundNBT();
    }

    public void release() {
        this.minecraftServer = null;
        this.scheduledEvents.clear();
        this.scheduledTickEvents.clear();
        this.playerMap.clear();
        this.fakePlayerMap.clear();
        this.overworld = null;
        this.levelMap.clear();
        this.worlds.clear();
        this.data = null;
    }

    public void updateWorldList() {
        this.worlds.clear();
        this.worlds.addAll(this.levelMap.values());
    }

    @Override
    public AttachedData getData() {
        if (this.data == null) {
            this.data = new AttachedData(this);
        }
        return this.data;
    }

    public List<ServerWorldJS> getWorlds() {
        return this.worlds;
    }

    public ServerWorldJS getOverworld() {
        return this.overworld;
    }

    public MinecraftServer getMinecraftServer() {
        return this.minecraftServer;
    }

    public boolean isRunning() {
        return this.getMinecraftServer().func_71278_l();
    }

    public boolean getHardcore() {
        return this.getMinecraftServer().func_71199_h();
    }

    public boolean isSinglePlayer() {
        return this.getMinecraftServer().func_71264_H();
    }

    public boolean isDedicated() {
        return this.getMinecraftServer().func_71262_S();
    }

    public String getMotd() {
        return this.getMinecraftServer().func_71273_Y();
    }

    public void setMotd(ITextComponent text) {
        this.getMinecraftServer().func_71205_p(text.getString());
    }

    public void stop() {
        this.getMinecraftServer().close();
    }

    @Override
    public Text getName() {
        return Text.of(this.getMinecraftServer().func_213142_bd());
    }

    @Override
    public Text getDisplayName() {
        return Text.of(this.getMinecraftServer().func_195573_aM().func_197019_b());
    }

    @Override
    public void tell(ITextComponent message) {
        this.getMinecraftServer().func_145747_a(message, Util.field_240973_b_);
        for (ServerPlayerEntity player : this.getMinecraftServer().func_184103_al().func_181057_v()) {
            player.func_145747_a(message, Util.field_240973_b_);
        }
    }

    @Override
    public void setStatusMessage(ITextComponent message) {
        for (ServerPlayerEntity player : this.getMinecraftServer().func_184103_al().func_181057_v()) {
            player.func_146105_b(message, true);
        }
    }

    @Override
    public int runCommand(String command) {
        return this.getMinecraftServer().func_195571_aL().func_197059_a(this.getMinecraftServer().func_195573_aM(), command);
    }

    @Override
    public int runCommandSilent(String command) {
        return this.getMinecraftServer().func_195571_aL().func_197059_a(this.getMinecraftServer().func_195573_aM().func_197031_a(), command);
    }

    public WorldJS getLevel(String dimension) {
        ServerWorldJS world = this.levelMap.get(dimension);
        if (world == null) {
            world = new ServerWorldJS(this, this.getMinecraftServer().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dimension))));
            this.levelMap.put(dimension, world);
            this.updateWorldList();
            new AttachWorldDataEvent(world).invoke();
        }
        return world;
    }

    @Deprecated
    public WorldJS getWorld(String dimension) {
        return this.getLevel(dimension);
    }

    public WorldJS getLevel(World minecraftLevel) {
        ServerWorldJS world = this.levelMap.get(minecraftLevel.func_234923_W_().func_240901_a_().toString());
        if (world == null) {
            world = new ServerWorldJS(this, (ServerWorld)minecraftLevel);
            this.levelMap.put(minecraftLevel.func_234923_W_().func_240901_a_().toString(), world);
            this.updateWorldList();
            new AttachWorldDataEvent(world).invoke();
        }
        return world;
    }

    @Deprecated
    public WorldJS getWorld(World minecraftLevel) {
        return this.getLevel(minecraftLevel);
    }

    @Nullable
    public ServerPlayerJS getPlayer(UUID uuid) {
        ServerPlayerDataJS p = this.playerMap.get(uuid);
        if (p == null) {
            return null;
        }
        return p.getPlayer();
    }

    @Nullable
    public ServerPlayerJS getPlayer(String name) {
        if ((name = name.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        UUID uuid = UUIDWrapper.fromString((Object)name);
        if (uuid != null) {
            return this.getPlayer(uuid);
        }
        for (ServerPlayerDataJS p : this.playerMap.values()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p.getPlayer();
        }
        for (ServerPlayerDataJS p : this.playerMap.values()) {
            if (!p.getName().toLowerCase().contains(name)) continue;
            return p.getPlayer();
        }
        return null;
    }

    @Nullable
    public ServerPlayerJS getPlayer(PlayerEntity minecraftPlayer) {
        return this.getPlayer(minecraftPlayer.func_110124_au());
    }

    public EntityArrayList getPlayers() {
        return new EntityArrayList((WorldJS)this.overworld, this.getMinecraftServer().func_184103_al().func_181057_v());
    }

    public EntityArrayList getEntities() {
        EntityArrayList list = new EntityArrayList((WorldJS)this.overworld, 10);
        for (ServerWorldJS world : this.worlds) {
            list.addAll(world.getEntities());
        }
        return list;
    }

    public EntityArrayList getEntities(String filter) {
        EntityArrayList list = new EntityArrayList((WorldJS)this.overworld, 10);
        for (ServerWorldJS world : this.worlds) {
            list.addAll(world.getEntities(filter));
        }
        return list;
    }

    public ScheduledEvent schedule(long timer, @Nullable Object data, IScheduledEventCallback event) {
        ScheduledEvent e = new ScheduledEvent(this, false, timer, System.currentTimeMillis() + timer, data, event);
        this.scheduledEvents.add(e);
        return e;
    }

    public ScheduledEvent schedule(long timer, IScheduledEventCallback event) {
        return this.schedule(timer, null, event);
    }

    public ScheduledEvent scheduleInTicks(long ticks, @Nullable Object data, IScheduledEventCallback event) {
        ScheduledEvent e = new ScheduledEvent(this, true, ticks, this.overworld.getTime() + ticks, data, event);
        this.scheduledTickEvents.add(e);
        return e;
    }

    public ScheduledEvent scheduleInTicks(long ticks, IScheduledEventCallback event) {
        return this.scheduleInTicks(ticks, null, event);
    }

    public String toString() {
        return "Server";
    }

    @Nullable
    public AdvancementJS getAdvancement(ResourceLocation id) {
        Advancement a = this.getMinecraftServer().func_191949_aK().func_192778_a(id);
        return a == null ? null : new AdvancementJS(a);
    }

    public void sendDataToAll(String channel, @Nullable CompoundNBT data) {
        new SendDataFromServerMessage(channel, data).sendToAll(this.getMinecraftServer());
    }
}

