/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe.ingredientaction;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ContainerInventory;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.kubejs.recipe.ingredientaction.DamageAction;
import dev.latvian.kubejs.recipe.ingredientaction.IngredientActionFilter;
import dev.latvian.kubejs.recipe.ingredientaction.KeepAction;
import dev.latvian.kubejs.recipe.ingredientaction.ReplaceAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public abstract class IngredientAction
extends IngredientActionFilter {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Map<String, Function<JsonObject, IngredientAction>> FACTORY_MAP = new HashMap<String, Function<JsonObject, IngredientAction>>();

    public static List<IngredientAction> parseList(JsonElement json) {
        if (json == null || !json.isJsonArray()) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        for (JsonElement e : json.getAsJsonArray()) {
            JsonObject o = e.getAsJsonObject();
            Function<JsonObject, IngredientAction> factory = FACTORY_MAP.get(o.has("type") ? o.get("type").getAsString() : "");
            IngredientAction action = factory == null ? null : factory.apply(o);
            if (action == null) continue;
            action.filterIndex = o.has("filter_index") ? o.get("filter_index").getAsInt() : -1;
            action.filterIngredient = o.has("filter_ingredient") ? IngredientJS.of(o.get("filter_ingredient")) : null;
            list.add(action);
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    public static List<IngredientAction> readList(PacketBuffer buf) {
        int s = buf.func_150792_a();
        if (s <= 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < s; ++i) {
            IngredientAction action;
            Function<JsonObject, IngredientAction> factory = FACTORY_MAP.get(buf.func_150789_c(Short.MAX_VALUE));
            IngredientAction ingredientAction = action = factory == null ? null : factory.apply((JsonObject)GSON.fromJson(buf.func_150789_c(Short.MAX_VALUE), JsonObject.class));
            if (action == null) continue;
            action.filterIndex = buf.func_150792_a();
            String ij = buf.func_150789_c(Short.MAX_VALUE);
            action.filterIngredient = ij.isEmpty() ? null : IngredientJS.of(GSON.fromJson(ij, JsonObject.class));
            list.add(action);
        }
        return list.isEmpty() ? Collections.emptyList() : list;
    }

    public static void writeList(PacketBuffer buf, List<IngredientAction> list) {
        if (list == null || list.isEmpty()) {
            buf.func_150787_b(0);
            return;
        }
        buf.func_150787_b(list.size());
        for (IngredientAction action : list) {
            buf.func_211400_a(action.getType(), Short.MAX_VALUE);
            JsonObject json = new JsonObject();
            action.toJson(json);
            buf.func_211400_a(GSON.toJson((JsonElement)json), Short.MAX_VALUE);
            buf.func_150787_b(action.filterIndex);
            buf.func_211400_a(action.filterIngredient == null ? "" : GSON.toJson(action.filterIngredient.toJson()), Short.MAX_VALUE);
        }
    }

    public static ItemStack getRemaining(CraftingInventory container, int index, List<IngredientAction> ingredientActions) {
        ItemStack stack = container.func_70301_a(index);
        if (stack == null || stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (IngredientAction action : ingredientActions) {
            if (!action.checkFilter(index, stack)) continue;
            return action.transform(stack.func_77946_l(), index, container);
        }
        return ContainerInventory.getContainerItem(stack);
    }

    public abstract ItemStack transform(ItemStack var1, int var2, CraftingInventory var3);

    public abstract String getType();

    public void toJson(JsonObject json) {
    }

    public final JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", this.getType());
        if (this.filterIngredient != null) {
            json.add("filter_ingredient", this.filterIngredient.toJson());
        }
        if (this.filterIndex != -1) {
            json.addProperty("filter_index", (Number)this.filterIndex);
        }
        this.toJson(json);
        return json;
    }

    static {
        FACTORY_MAP.put("custom", json -> new CustomIngredientAction(json.get("id").getAsString()));
        FACTORY_MAP.put("damage", json -> new DamageAction(json.get("damage").getAsInt()));
        FACTORY_MAP.put("replace", json -> new ReplaceAction(ItemStackJS.of(json.get("item")).getItemStack()));
        FACTORY_MAP.put("keep", json -> new KeepAction());
    }
}

