/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.player;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.entity.RayTraceResultJS;
import dev.latvian.kubejs.net.SendDataFromClientMessage;
import dev.latvian.kubejs.player.ClientPlayerDataJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.player.PlayerStatsJS;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.Nullable;

public class ClientPlayerJS
extends PlayerJS<PlayerEntity> {
    private final boolean isSelf;

    public ClientPlayerJS(ClientPlayerDataJS d, PlayerEntity p, boolean s) {
        super(d, d.getWorld(), p);
        this.isSelf = s;
    }

    public boolean isSelf() {
        return this.isSelf;
    }

    @Override
    public PlayerStatsJS getStats() {
        if (!this.isSelf()) {
            throw new IllegalStateException("Can't access other player stats!");
        }
        return new PlayerStatsJS(this, ((ClientPlayerEntity)this.minecraftPlayer).func_146107_m());
    }

    @Override
    public void paint(CompoundNBT tag) {
        if (this.isSelf()) {
            KubeJS.PROXY.paint(tag);
        }
    }

    @Override
    public boolean isMiningBlock() {
        return this.isSelf() && Minecraft.func_71410_x().field_71442_b.func_181040_m();
    }

    @Override
    public void sendData(String channel, @Nullable CompoundNBT data) {
        if (!channel.isEmpty() && this.isSelf()) {
            new SendDataFromClientMessage(channel, data).sendToServer();
        }
    }

    @Override
    public RayTraceResultJS rayTrace(double distance) {
        return this.isSelf ? new RayTraceResultJS(this, Minecraft.func_71410_x().field_71476_x, distance) : super.rayTrace(distance);
    }
}

