/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient.forge;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class IgnoreNBTIngredient
extends Ingredient {
    public static final IIngredientSerializer<IgnoreNBTIngredient> SERIALIZER = new IIngredientSerializer<IgnoreNBTIngredient>(){

        public IgnoreNBTIngredient parse(PacketBuffer buf) {
            ItemStack stack = buf.func_150791_c();
            stack.func_77982_d(null);
            return new IgnoreNBTIngredient(stack);
        }

        public IgnoreNBTIngredient parse(JsonObject json) {
            ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(json.get("item").getAsString())));
            stack.func_77982_d(null);
            return new IgnoreNBTIngredient(stack);
        }

        public void write(PacketBuffer buf, IgnoreNBTIngredient ingredient) {
            buf.func_150788_a(ingredient.item);
        }
    };
    private final ItemStack item;

    public IgnoreNBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.item = stack;
    }

    public boolean test(@Nullable ItemStack stack) {
        return stack != null && !stack.func_190926_b() && stack.func_77973_b() == this.item.func_77973_b();
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "kubejs:ignore_nbt");
        json.addProperty("item", this.item.func_77973_b().getRegistryName().toString());
        return json;
    }
}

