/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.core.IngredientKJS;
import dev.latvian.kubejs.item.ingredient.IngredientWithCustomPredicateJS;
import dev.latvian.kubejs.recipe.RecipeEventJS;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomPredicateIngredient
extends Ingredient {
    public static final IIngredientSerializer<CustomPredicateIngredient> SERIALIZER = new IIngredientSerializer<CustomPredicateIngredient>(){

        public CustomPredicateIngredient parse(PacketBuffer buf) {
            return new CustomPredicateIngredient(Ingredient.func_199566_b((PacketBuffer)buf), buf.func_179253_g(), false);
        }

        public CustomPredicateIngredient parse(JsonObject json) {
            return new CustomPredicateIngredient(CraftingHelper.getIngredient((JsonElement)json.get("ingredient")), UUID.fromString(json.get("uuid").getAsString()), true);
        }

        public void write(PacketBuffer buf, CustomPredicateIngredient ingredient) {
            ingredient.ingredient.func_199564_a(buf);
            buf.func_179252_a(ingredient.uuid);
        }
    };
    private final Ingredient ingredient;
    private final UUID uuid;
    private final boolean isServer;

    private CustomPredicateIngredient(Ingredient in, UUID id, boolean s) {
        super(Stream.empty());
        this.ingredient = in;
        this.uuid = id;
        this.isServer = s;
    }

    @NotNull
    public ItemStack[] func_193365_a() {
        return ((IngredientKJS)this.ingredient).getItemsKJS();
    }

    @NotNull
    public IntList func_194139_b() {
        return this.ingredient.func_194139_b();
    }

    public boolean test(@Nullable ItemStack target) {
        if (this.isServer && target != null && this.ingredient.test(target) && RecipeEventJS.customIngredientMap != null) {
            IngredientWithCustomPredicateJS i = RecipeEventJS.customIngredientMap.get(this.uuid);
            return i != null && i.predicate.test(target);
        }
        return false;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<CustomPredicateIngredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "kubejs:custom_predicate");
        json.add("ingredient", this.ingredient.func_200304_c());
        json.addProperty("uuid", this.uuid.toString());
        return json;
    }

    public boolean func_203189_d() {
        return this.ingredient.func_203189_d();
    }
}

