/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.Tags;
import dev.latvian.kubejs.util.UtilsJS;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class TagIngredientJS
implements IngredientJS {
    private static final Map<String, TagIngredientJS> tagIngredientCache = new HashMap<String, TagIngredientJS>();
    private final ResourceLocation tag;
    private ITag<Item> actualTag;

    public static TagIngredientJS createTag(String tag) {
        TagIngredientJS i = tagIngredientCache.computeIfAbsent(tag, TagIngredientJS::new);
        if (RecipeJS.itemErrors && i.getActualTag().func_230236_b_().isEmpty()) {
            throw new RecipeExceptionJS("Tag '#" + tag + "' doesn't contain any items!").error();
        }
        return i;
    }

    public static void clearTagCache() {
        tagIngredientCache.clear();
    }

    private TagIngredientJS(String t) {
        this.tag = UtilsJS.getMCID(t);
    }

    public String getTag() {
        return this.tag.toString();
    }

    public ITag<Item> getActualTag() {
        if (this.actualTag == null) {
            this.actualTag = Tags.items().func_199910_a(this.tag);
            if (this.actualTag == null) {
                this.actualTag = Tag.func_241284_a_();
            }
        }
        return this.actualTag;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        return !stack.isEmpty() && this.getActualTag().func_230235_a_((Object)stack.getItem());
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        return !stack.func_190926_b() && this.getActualTag().func_230235_a_((Object)stack.func_77973_b());
    }

    @Override
    public boolean testVanillaItem(Item item) {
        return item != Items.field_190931_a && this.getActualTag().func_230235_a_((Object)item);
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        ITag<Item> t = this.getActualTag();
        if (t.func_230236_b_().size() > 0) {
            LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
            for (Item item : t.func_230236_b_()) {
                set.add(new ItemStackJS(new ItemStack((IItemProvider)item)));
            }
            return set;
        }
        return Collections.emptySet();
    }

    @Override
    public Set<Item> getVanillaItems() {
        ITag<Item> t = this.getActualTag();
        if (t.func_230236_b_().size() > 0) {
            return new LinkedHashSet<Item>(t.func_230236_b_());
        }
        return Collections.emptySet();
    }

    @Override
    public ItemStackJS getFirst() {
        Iterator iterator;
        ITag<Item> t = this.getActualTag();
        if (t.func_230236_b_().size() > 0 && (iterator = t.func_230236_b_().iterator()).hasNext()) {
            Item item = (Item)iterator.next();
            return new ItemStackJS(new ItemStack((IItemProvider)item));
        }
        throw new RecipeExceptionJS("Tag " + this.tag + " has no items");
    }

    public String toString() {
        return "'#" + this.tag + "'";
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("tag", this.tag.toString());
        return json;
    }

    @Override
    public boolean anyStackMatches(IngredientJS ingredient) {
        if (ingredient instanceof TagIngredientJS && this.tag.equals((Object)((TagIngredientJS)ingredient).tag)) {
            return true;
        }
        return IngredientJS.super.anyStackMatches(ingredient);
    }

    @Override
    public Ingredient createVanillaIngredient() {
        return Ingredient.func_199805_a(this.getActualTag());
    }
}

